/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.xpack.spatial.index.fielddata.CentroidCalculator;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.Extent;

public class TriangleTreeWriter {
    private final TriangleTreeNode node;
    private final CoordinateEncoder coordinateEncoder;
    private final CentroidCalculator centroidCalculator;
    private Extent extent;

    public TriangleTreeWriter(List<ShapeField.DecodedTriangle> triangles, CoordinateEncoder coordinateEncoder, CentroidCalculator centroidCalculator) {
        this.coordinateEncoder = coordinateEncoder;
        this.centroidCalculator = centroidCalculator;
        this.extent = new Extent();
        this.node = this.build(triangles);
    }

    public void writeTo(ByteBuffersDataOutput out) throws IOException {
        out.writeInt(this.coordinateEncoder.encodeX(this.centroidCalculator.getX()));
        out.writeInt(this.coordinateEncoder.encodeY(this.centroidCalculator.getY()));
        this.centroidCalculator.getDimensionalShapeType().writeTo(out);
        out.writeVLong(Double.doubleToLongBits(this.centroidCalculator.sumWeight()));
        this.extent.writeCompressed(out);
        this.node.writeTo(out);
    }

    private void addToExtent(TriangleTreeNode treeNode) {
        this.extent.addRectangle(treeNode.minX, treeNode.minY, treeNode.maxX, treeNode.maxY);
    }

    private TriangleTreeNode build(List<ShapeField.DecodedTriangle> triangles) {
        if (triangles.size() == 1) {
            TriangleTreeNode triangleTreeNode = new TriangleTreeNode(triangles.get(0));
            this.addToExtent(triangleTreeNode);
            return triangleTreeNode;
        }
        TriangleTreeNode[] nodes = new TriangleTreeNode[triangles.size()];
        for (int i = 0; i < triangles.size(); ++i) {
            nodes[i] = new TriangleTreeNode(triangles.get(i));
            this.addToExtent(nodes[i]);
        }
        return this.createTree(nodes, 0, triangles.size() - 1, true);
    }

    private TriangleTreeNode createTree(TriangleTreeNode[] components, int low, int high, boolean splitX) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            Comparator<TriangleTreeNode> comparator = splitX ? Comparator.comparingInt(left -> ((TriangleTreeNode)left).minX).thenComparingInt(left -> ((TriangleTreeNode)left).maxX) : Comparator.comparingInt(left -> ((TriangleTreeNode)left).minY).thenComparingInt(left -> ((TriangleTreeNode)left).maxY);
            ArrayUtil.select((Object[])components, (int)low, (int)(high + 1), (int)mid, comparator);
        }
        TriangleTreeNode newNode = components[mid];
        newNode.left = this.createTree(components, low, mid - 1, !splitX);
        newNode.right = this.createTree(components, mid + 1, high, !splitX);
        if (newNode.left != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.left.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.left.maxY);
        }
        if (newNode.right != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.right.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.right.maxY);
        }
        return newNode;
    }

    private static class TriangleTreeNode {
        private int minY;
        private int maxY;
        private int minX;
        private int maxX;
        private TriangleTreeNode left;
        private TriangleTreeNode right;
        private final ShapeField.DecodedTriangle component;
        private final TYPE type;

        private TriangleTreeNode(ShapeField.DecodedTriangle component) {
            this.minY = Math.min(Math.min(component.aY, component.bY), component.cY);
            this.maxY = Math.max(Math.max(component.aY, component.bY), component.cY);
            this.minX = Math.min(Math.min(component.aX, component.bX), component.cX);
            this.maxX = Math.max(Math.max(component.aX, component.bX), component.cX);
            this.component = component;
            this.type = TriangleTreeNode.getType(component);
        }

        private static TYPE getType(ShapeField.DecodedTriangle triangle) {
            if (triangle.aX == triangle.bX && triangle.aY == triangle.bY) {
                if (triangle.aX == triangle.cX && triangle.aY == triangle.cY) {
                    return TYPE.POINT;
                }
                return TYPE.LINE;
            }
            if (triangle.aX == triangle.cX && triangle.aY == triangle.cY || triangle.bX == triangle.cX && triangle.bY == triangle.cY) {
                return TYPE.LINE;
            }
            return TYPE.TRIANGLE;
        }

        private void writeTo(ByteBuffersDataOutput out) throws IOException {
            ByteBuffersDataOutput scratchBuffer = ByteBuffersDataOutput.newResettableInstance();
            this.writeMetadata(out);
            this.writeComponent(out);
            if (this.left != null) {
                this.left.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
            if (this.right != null) {
                this.right.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
        }

        private void writeNode(ByteBuffersDataOutput out, int parentMaxX, int parentMaxY, ByteBuffersDataOutput scratchBuffer) throws IOException {
            out.writeVLong((long)parentMaxX - (long)this.maxX);
            out.writeVLong((long)parentMaxY - (long)this.maxY);
            int size = this.nodeSize(false, parentMaxX, parentMaxY, scratchBuffer);
            out.writeVInt(size);
            this.writeMetadata(out);
            this.writeComponent(out);
            if (this.left != null) {
                this.left.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
            if (this.right != null) {
                int rightSize = this.right.nodeSize(true, this.maxX, this.maxY, scratchBuffer);
                out.writeVInt(rightSize);
                this.right.writeNode(out, this.maxX, this.maxY, scratchBuffer);
            }
        }

        private void writeMetadata(ByteBuffersDataOutput out) {
            byte metadata = 0;
            metadata = (byte)(metadata | (this.left != null ? 1 : 0));
            metadata = (byte)(metadata | (this.right != null ? 2 : 0));
            if (this.type == TYPE.POINT) {
                metadata = (byte)(metadata | 4);
            } else if (this.type == TYPE.LINE) {
                metadata = (byte)(metadata | 8);
            } else {
                metadata = (byte)(metadata | (this.component.ab ? 16 : 0));
                metadata = (byte)(metadata | (this.component.bc ? 32 : 0));
                metadata = (byte)(metadata | (this.component.ca ? 64 : 0));
            }
            out.writeByte(metadata);
        }

        private void writeComponent(ByteBuffersDataOutput out) throws IOException {
            if (this.type == TYPE.POINT) {
                out.writeVLong((long)this.maxX - (long)this.component.aX);
                out.writeVLong((long)this.maxY - (long)this.component.aY);
            } else if (this.type == TYPE.LINE) {
                out.writeVLong((long)this.maxX - (long)this.component.aX);
                out.writeVLong((long)this.maxY - (long)this.component.aY);
                out.writeVLong((long)this.maxX - (long)this.component.bX);
                out.writeVLong((long)this.maxY - (long)this.component.bY);
            } else {
                out.writeVLong((long)this.maxX - (long)this.component.aX);
                out.writeVLong((long)this.maxY - (long)this.component.aY);
                out.writeVLong((long)this.maxX - (long)this.component.bX);
                out.writeVLong((long)this.maxY - (long)this.component.bY);
                out.writeVLong((long)this.maxX - (long)this.component.cX);
                out.writeVLong((long)this.maxY - (long)this.component.cY);
            }
        }

        private int nodeSize(boolean includeBox, int parentMaxX, int parentMaxY, ByteBuffersDataOutput scratchBuffer) throws IOException {
            int size = 0;
            ++size;
            size += this.componentSize(scratchBuffer);
            if (this.left != null) {
                size += this.left.nodeSize(true, this.maxX, this.maxY, scratchBuffer);
            }
            if (this.right != null) {
                int rightSize = this.right.nodeSize(true, this.maxX, this.maxY, scratchBuffer);
                scratchBuffer.reset();
                scratchBuffer.writeVLong((long)rightSize);
                size = (int)((long)size + scratchBuffer.size());
                size += rightSize;
            }
            if (includeBox) {
                int jumpSize = size;
                scratchBuffer.reset();
                scratchBuffer.writeVLong((long)parentMaxX - (long)this.maxX);
                scratchBuffer.writeVLong((long)parentMaxY - (long)this.maxY);
                scratchBuffer.writeVLong((long)jumpSize);
                size = (int)((long)size + scratchBuffer.size());
            }
            return size;
        }

        private int componentSize(ByteBuffersDataOutput scratchBuffer) throws IOException {
            scratchBuffer.reset();
            if (this.type == TYPE.POINT) {
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.aX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.aY);
            } else if (this.type == TYPE.LINE) {
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.aX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.aY);
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.bX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.bY);
            } else {
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.aX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.aY);
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.bX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.bY);
                scratchBuffer.writeVLong((long)this.maxX - (long)this.component.cX);
                scratchBuffer.writeVLong((long)this.maxY - (long)this.component.cY);
            }
            return Math.toIntExact(scratchBuffer.size());
        }

        public static enum TYPE {
            POINT,
            LINE,
            TRIANGLE;

        }
    }
}

