/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.DimensionalShapeType;
import org.elasticsearch.xpack.spatial.index.fielddata.Extent;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;

public class TriangleTreeReader {
    private final ByteArrayDataInput input;
    private final CoordinateEncoder coordinateEncoder;
    private final Tile2D tile2D;
    private final Extent extent;
    private int treeOffset;
    private int docValueOffset;

    public TriangleTreeReader(CoordinateEncoder coordinateEncoder) {
        this.coordinateEncoder = coordinateEncoder;
        this.tile2D = new Tile2D();
        this.extent = new Extent();
        this.input = new ByteArrayDataInput();
    }

    public void reset(BytesRef bytesRef) throws IOException {
        this.input.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        this.docValueOffset = bytesRef.offset;
        this.treeOffset = 0;
    }

    public Extent getExtent() {
        if (this.treeOffset == 0) {
            this.getSumCentroidWeight();
            Extent.readFromCompressed(this.input, this.extent);
            this.treeOffset = this.input.getPosition();
        } else {
            this.input.setPosition(this.treeOffset);
        }
        return this.extent;
    }

    public double getCentroidX() {
        this.input.setPosition(this.docValueOffset + 0);
        return this.coordinateEncoder.decodeX(this.input.readInt());
    }

    public double getCentroidY() {
        this.input.setPosition(this.docValueOffset + 4);
        return this.coordinateEncoder.decodeY(this.input.readInt());
    }

    public DimensionalShapeType getDimensionalShapeType() {
        this.input.setPosition(this.docValueOffset + 8);
        return DimensionalShapeType.readFrom(this.input);
    }

    public double getSumCentroidWeight() {
        this.input.setPosition(this.docValueOffset + 9);
        return Double.longBitsToDouble(this.input.readVLong());
    }

    public GeoRelation relateTile(int minX, int minY, int maxX, int maxY) {
        int aX;
        Extent extent = this.getExtent();
        int thisMaxX = extent.maxX();
        int thisMinX = extent.minX();
        int thisMaxY = extent.maxY();
        int thisMinY = extent.minY();
        if (thisMinX >= maxX || thisMaxX < minX || thisMinY > maxY || thisMaxY <= minY) {
            return GeoRelation.QUERY_DISJOINT;
        }
        if (minX <= thisMinX && maxX >= thisMaxX && minY <= thisMinY && maxY >= thisMaxY) {
            return GeoRelation.QUERY_CROSSES;
        }
        GeoRelation rel = GeoRelation.QUERY_DISJOINT;
        this.tile2D.setValues(minX, maxX, minY, maxY);
        byte metadata = this.input.readByte();
        if ((metadata & 4) == 4) {
            int y;
            int x = Math.toIntExact((long)thisMaxX - this.input.readVLong());
            if (this.tile2D.contains(x, y = Math.toIntExact((long)thisMaxY - this.input.readVLong()))) {
                return GeoRelation.QUERY_CROSSES;
            }
            thisMinX = x;
        } else if ((metadata & 8) == 8) {
            int bY;
            int bX;
            int aY;
            aX = Math.toIntExact((long)thisMaxX - this.input.readVLong());
            if (this.tile2D.intersectsLine(aX, aY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), bX = Math.toIntExact((long)thisMaxX - this.input.readVLong()), bY = Math.toIntExact((long)thisMaxY - this.input.readVLong()))) {
                return GeoRelation.QUERY_CROSSES;
            }
            thisMinX = aX;
        } else {
            boolean ca;
            int cY;
            int cX;
            boolean bc;
            int bY;
            int bX;
            boolean ab;
            int aY;
            aX = Math.toIntExact((long)thisMaxX - this.input.readVLong());
            rel = this.tile2D.relateTriangle(aX, aY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), ab = (metadata & 0x10) == 16, bX = Math.toIntExact((long)thisMaxX - this.input.readVLong()), bY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), bc = (metadata & 0x20) == 32, cX = Math.toIntExact((long)thisMaxX - this.input.readVLong()), cY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), ca = (metadata & 0x40) == 64);
            if (rel == GeoRelation.QUERY_CROSSES) {
                return GeoRelation.QUERY_CROSSES;
            }
            thisMinX = aX;
        }
        if ((metadata & 1) == 1) {
            GeoRelation left = this.relateTile(this.tile2D, false, thisMaxX, thisMaxY);
            if (left == GeoRelation.QUERY_CROSSES) {
                return GeoRelation.QUERY_CROSSES;
            }
            if (left == GeoRelation.QUERY_INSIDE) {
                rel = left;
            }
        }
        if ((metadata & 2) == 2 && this.tile2D.maxX >= thisMinX) {
            GeoRelation right = this.relateTile(this.tile2D, false, thisMaxX, thisMaxY);
            if (right == GeoRelation.QUERY_CROSSES) {
                return GeoRelation.QUERY_CROSSES;
            }
            if (right == GeoRelation.QUERY_INSIDE) {
                rel = right;
            }
        }
        return rel;
    }

    private GeoRelation relateTile(Tile2D tile2D, boolean splitX, int parentMaxX, int parentMaxY) {
        int thisMaxX = Math.toIntExact((long)parentMaxX - this.input.readVLong());
        int thisMaxY = Math.toIntExact((long)parentMaxY - this.input.readVLong());
        GeoRelation rel = GeoRelation.QUERY_DISJOINT;
        int size = this.input.readVInt();
        if (tile2D.minY <= thisMaxY && tile2D.minX <= thisMaxX) {
            int aY;
            int aX;
            int thisMinY;
            int thisMinX;
            byte metadata = this.input.readByte();
            if ((metadata & 4) == 4) {
                int y;
                int x = Math.toIntExact((long)thisMaxX - this.input.readVLong());
                if (tile2D.contains(x, y = Math.toIntExact((long)thisMaxY - this.input.readVLong()))) {
                    return GeoRelation.QUERY_CROSSES;
                }
                thisMinX = x;
                thisMinY = y;
            } else if ((metadata & 8) == 8) {
                int bY;
                int bX;
                aX = Math.toIntExact((long)thisMaxX - this.input.readVLong());
                if (tile2D.intersectsLine(aX, aY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), bX = Math.toIntExact((long)thisMaxX - this.input.readVLong()), bY = Math.toIntExact((long)thisMaxY - this.input.readVLong()))) {
                    return GeoRelation.QUERY_CROSSES;
                }
                thisMinX = aX;
                thisMinY = Math.min(aY, bY);
            } else {
                boolean ca;
                int cY;
                int cX;
                boolean bc;
                int bY;
                int bX;
                boolean ab;
                aX = Math.toIntExact((long)thisMaxX - this.input.readVLong());
                rel = tile2D.relateTriangle(aX, aY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), ab = (metadata & 0x10) == 16, bX = Math.toIntExact((long)thisMaxX - this.input.readVLong()), bY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), bc = (metadata & 0x20) == 32, cX = Math.toIntExact((long)thisMaxX - this.input.readVLong()), cY = Math.toIntExact((long)thisMaxY - this.input.readVLong()), ca = (metadata & 0x40) == 64);
                if (rel == GeoRelation.QUERY_CROSSES) {
                    return GeoRelation.QUERY_CROSSES;
                }
                thisMinX = aX;
                thisMinY = Math.min(Math.min(aY, bY), cY);
            }
            if ((metadata & 1) == 1) {
                GeoRelation left = this.relateTile(tile2D, !splitX, thisMaxX, thisMaxY);
                if (left == GeoRelation.QUERY_CROSSES) {
                    return GeoRelation.QUERY_CROSSES;
                }
                if (left == GeoRelation.QUERY_INSIDE) {
                    rel = left;
                }
            }
            if ((metadata & 2) == 2) {
                int rightSize = this.input.readVInt();
                if (!splitX && tile2D.maxY >= thisMinY || splitX && tile2D.maxX >= thisMinX) {
                    GeoRelation right = this.relateTile(tile2D, !splitX, thisMaxX, thisMaxY);
                    if (right == GeoRelation.QUERY_CROSSES) {
                        return GeoRelation.QUERY_CROSSES;
                    }
                    if (right == GeoRelation.QUERY_INSIDE) {
                        rel = right;
                    }
                } else {
                    this.input.skipBytes((long)rightSize);
                }
            }
        } else {
            this.input.skipBytes((long)size);
        }
        return rel;
    }

    private static class Tile2D {
        protected int minX;
        protected int maxX;
        protected int minY;
        protected int maxY;

        Tile2D() {
        }

        private void setValues(int minX, int maxX, int minY, int maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }

        public boolean contains(int x, int y) {
            return !(x <= this.minX || x > this.maxX || y < this.minY || y >= this.maxY);
        }

        private boolean intersectsLine(int aX, int aY, int bX, int bY) {
            if (this.contains(aX, aY) || this.contains(bX, bY)) {
                return true;
            }
            int tMinX = StrictMath.min(aX, bX);
            int tMaxX = StrictMath.max(aX, bX);
            int tMinY = StrictMath.min(aY, bY);
            int tMaxY = StrictMath.max(aY, bY);
            if (tMaxX <= this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY <= this.minY) {
                return false;
            }
            return this.edgeIntersectsQuery(aX, aY, bX, bY);
        }

        private GeoRelation relateTriangle(int aX, int aY, boolean ab, int bX, int bY, boolean bc, int cX, int cY, boolean ca) {
            int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
            int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
            int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
            int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
            if (tMaxX <= this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY <= this.minY) {
                return GeoRelation.QUERY_DISJOINT;
            }
            if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
                return GeoRelation.QUERY_CROSSES;
            }
            boolean within = false;
            if (this.edgeIntersectsQuery(aX, aY, bX, bY)) {
                if (ab) {
                    return GeoRelation.QUERY_CROSSES;
                }
                within = true;
            }
            if (this.edgeIntersectsQuery(bX, bY, cX, cY)) {
                if (bc) {
                    return GeoRelation.QUERY_CROSSES;
                }
                within = true;
            }
            if (this.edgeIntersectsQuery(cX, cY, aX, aY)) {
                if (ca) {
                    return GeoRelation.QUERY_CROSSES;
                }
                within = true;
            }
            if (within || Tile2D.pointInTriangle(tMinX, tMaxX, tMinY, tMaxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
                return GeoRelation.QUERY_INSIDE;
            }
            return GeoRelation.QUERY_DISJOINT;
        }

        private boolean edgeIntersectsQuery(int ax, int ay, int bx, int by) {
            if (Tile2D.boxesAreDisjoint(Math.min(ax, bx), Math.max(ax, bx), Math.min(ay, by), Math.max(ay, by), this.minX, this.maxX, this.minY, this.maxY)) {
                return false;
            }
            if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.maxY) <= 0 && GeoUtils.orient((double)this.minX, (double)this.maxY, (double)this.maxX, (double)this.maxY, (double)ax, (double)ay) * GeoUtils.orient((double)this.minX, (double)this.maxY, (double)this.maxX, (double)this.maxY, (double)bx, (double)by) <= 0) {
                return true;
            }
            if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.minY) <= 0 && GeoUtils.orient((double)this.maxX, (double)this.maxY, (double)this.maxX, (double)this.minY, (double)ax, (double)ay) * GeoUtils.orient((double)this.maxX, (double)this.maxY, (double)this.maxX, (double)this.minY, (double)bx, (double)by) <= 0) {
                return true;
            }
            if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.minY) <= 0 && GeoUtils.orient((double)this.maxX, (double)this.minY, (double)this.minX, (double)this.minY, (double)ax, (double)ay) * GeoUtils.orient((double)this.maxX, (double)this.minY, (double)this.minX, (double)this.minY, (double)bx, (double)by) <= 0) {
                return true;
            }
            return GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.maxY) <= 0 && GeoUtils.orient((double)this.minX, (double)this.minY, (double)this.minX, (double)this.maxY, (double)ax, (double)ay) * GeoUtils.orient((double)this.minX, (double)this.minY, (double)this.minX, (double)this.maxY, (double)bx, (double)by) <= 0;
        }

        private static boolean pointInTriangle(double minX, double maxX, double minY, double maxY, double x, double y, double aX, double aY, double bX, double bY, double cX, double cY) {
            if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
                int a = GeoUtils.orient((double)x, (double)y, (double)aX, (double)aY, (double)bX, (double)bY);
                int b = GeoUtils.orient((double)x, (double)y, (double)bX, (double)bY, (double)cX, (double)cY);
                if (a == 0 || b == 0 || a < 0 == b < 0) {
                    int c = GeoUtils.orient((double)x, (double)y, (double)cX, (double)cY, (double)aX, (double)aY);
                    return c == 0 || c < 0 == (b < 0 || a < 0);
                }
                return false;
            }
            return false;
        }

        private static boolean boxesAreDisjoint(int aMinX, int aMaxX, int aMinY, int aMaxY, int bMinX, int bMaxX, int bMinY, int bMaxY) {
            return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
        }
    }
}

