/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ErrorLogCategory {
    ACCESS_CONTROL,
    ADMIN,
    ADMIN_TOOL,
    BACKEND,
    CONFIG,
    CORE,
    DSCONFIG,
    EXTENSIONS,
    JEB,
    LOG,
    PLUGIN,
    PROTOCOL,
    PROXY,
    QUICKSETUP,
    REPLICATION,
    RUNTIME_INFORMATION,
    SCHEMA,
    TASK,
    THIRD_PARTY,
    TOOLS,
    UTIL,
    VERSION;


    public static ErrorLogCategory forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "accesscontrol": 
            case "access-control": 
            case "access_control": {
                return ACCESS_CONTROL;
            }
            case "admin": {
                return ADMIN;
            }
            case "admintool": 
            case "admin-tool": 
            case "admin_tool": {
                return ADMIN_TOOL;
            }
            case "backend": {
                return BACKEND;
            }
            case "config": {
                return CONFIG;
            }
            case "core": {
                return CORE;
            }
            case "dsconfig": {
                return DSCONFIG;
            }
            case "extensions": {
                return EXTENSIONS;
            }
            case "jeb": {
                return JEB;
            }
            case "log": {
                return LOG;
            }
            case "plugin": {
                return PLUGIN;
            }
            case "protocol": {
                return PROTOCOL;
            }
            case "proxy": {
                return PROXY;
            }
            case "quicksetup": {
                return QUICKSETUP;
            }
            case "replication": {
                return REPLICATION;
            }
            case "runtimeinformation": 
            case "runtime-information": 
            case "runtime_information": {
                return RUNTIME_INFORMATION;
            }
            case "schema": {
                return SCHEMA;
            }
            case "task": {
                return TASK;
            }
            case "thirdparty": 
            case "third-party": 
            case "third_party": {
                return THIRD_PARTY;
            }
            case "tools": {
                return TOOLS;
            }
            case "util": {
                return UTIL;
            }
            case "version": {
                return VERSION;
            }
        }
        return null;
    }
}

