/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.rollup.action.DeleteRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupCapsAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupJobsAction;
import org.elasticsearch.xpack.core.rollup.action.PutRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.RollupSearchAction;
import org.elasticsearch.xpack.core.rollup.action.StartRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.StopRollupJobAction;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.rollup.RollupFeatureSet;
import org.elasticsearch.xpack.rollup.action.TransportDeleteRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupCapsAction;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupIndexCapsAction;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportPutRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportRollupSearchAction;
import org.elasticsearch.xpack.rollup.action.TransportStartRollupAction;
import org.elasticsearch.xpack.rollup.action.TransportStopRollupAction;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;
import org.elasticsearch.xpack.rollup.rest.RestDeleteRollupJobAction;
import org.elasticsearch.xpack.rollup.rest.RestGetRollupCapsAction;
import org.elasticsearch.xpack.rollup.rest.RestGetRollupIndexCapsAction;
import org.elasticsearch.xpack.rollup.rest.RestGetRollupJobsAction;
import org.elasticsearch.xpack.rollup.rest.RestPutRollupJobAction;
import org.elasticsearch.xpack.rollup.rest.RestRollupSearchAction;
import org.elasticsearch.xpack.rollup.rest.RestStartRollupJobAction;
import org.elasticsearch.xpack.rollup.rest.RestStopRollupJobAction;

public class Rollup
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin {
    public static final int ROLLUP_VERSION_V1 = 1;
    public static final int ROLLUP_VERSION_V2 = 2;
    public static final int CURRENT_ROLLUP_VERSION = 2;
    public static final String TASK_THREAD_POOL_NAME = "rollup_indexing";
    public static final String SCHEDULE_THREAD_POOL_NAME = "rollup_scheduler";
    public static final String ROLLUP_TEMPLATE_VERSION_FIELD = "rollup-version";
    public static final Set<String> HEADER_FILTERS = new HashSet<String>(Arrays.asList("es-security-runas-user", "_xpack_security_authentication"));
    private final SetOnce<SchedulerEngine> schedulerEngine = new SetOnce();
    private final Settings settings;
    private final boolean transportClientMode;

    public Rollup(Settings settings) {
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.emptyList();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, RollupFeatureSet.class));
        return modules;
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestRollupSearchAction(), new RestPutRollupJobAction(), new RestStartRollupJobAction(), new RestStopRollupJobAction(), new RestDeleteRollupJobAction(), new RestGetRollupJobsAction(), new RestGetRollupCapsAction(), new RestGetRollupIndexCapsAction()});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)RollupSearchAction.INSTANCE, TransportRollupSearchAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutRollupJobAction.INSTANCE, TransportPutRollupJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartRollupJobAction.INSTANCE, TransportStartRollupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopRollupJobAction.INSTANCE, TransportStopRollupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteRollupJobAction.INSTANCE, TransportDeleteRollupJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRollupJobsAction.INSTANCE, TransportGetRollupJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRollupCapsAction.INSTANCE, TransportGetRollupCapsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRollupIndexCapsAction.INSTANCE, TransportGetRollupIndexCapsAction.class, new Class[0]));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        FixedExecutorBuilder indexing = new FixedExecutorBuilder(settings, TASK_THREAD_POOL_NAME, 4, 4, "xpack.rollup.task_thread_pool");
        return Collections.singletonList(indexing);
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        this.schedulerEngine.set((Object)new SchedulerEngine(this.settings, this.getClock()));
        return Collections.singletonList(new RollupJobTask.RollupJobPersistentTasksExecutor(client, (SchedulerEngine)this.schedulerEngine.get(), threadPool));
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public void close() {
        if (this.schedulerEngine.get() != null) {
            ((SchedulerEngine)this.schedulerEngine.get()).stop();
        }
    }
}

