/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.core.search.action.SubmitAsyncSearchRequest;
import org.elasticsearch.xpack.search.AsyncSearchTask;

public class TransportSubmitAsyncSearchAction
extends HandledTransportAction<SubmitAsyncSearchRequest, AsyncSearchResponse> {
    private static final Logger logger = LogManager.getLogger(TransportSubmitAsyncSearchAction.class);
    private final NodeClient nodeClient;
    private final Function<SearchRequest, InternalAggregation.ReduceContext> requestToAggReduceContextBuilder;
    private final TransportSearchAction searchAction;
    private final ThreadContext threadContext;
    private final AsyncTaskIndexService<AsyncSearchResponse> store;

    @Inject
    public TransportSubmitAsyncSearchAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NamedWriteableRegistry registry, Client client, NodeClient nodeClient, SearchService searchService, TransportSearchAction searchAction) {
        super("indices:data/read/async_search/submit", transportService, actionFilters, SubmitAsyncSearchRequest::new);
        this.nodeClient = nodeClient;
        this.requestToAggReduceContextBuilder = request -> searchService.aggReduceContextBuilder(request).forFinalReduction();
        this.searchAction = searchAction;
        this.threadContext = transportService.getThreadPool().getThreadContext();
        this.store = new AsyncTaskIndexService(".async-search", clusterService, this.threadContext, client, "async_search", AsyncSearchResponse::new, registry);
    }

    protected void doExecute(Task submitTask, final SubmitAsyncSearchRequest request, final ActionListener<AsyncSearchResponse> submitListener) {
        SearchRequest searchRequest = this.createSearchRequest(request, submitTask, request.getKeepAlive());
        final AsyncSearchTask searchTask = (AsyncSearchTask)this.taskManager.register("transport", SearchAction.INSTANCE.name(), (TaskAwareRequest)searchRequest);
        this.searchAction.execute((Task)searchTask, (ActionRequest)searchRequest, (ActionListener)searchTask.getSearchProgressActionListener());
        searchTask.addCompletionListener(new ActionListener<AsyncSearchResponse>(){

            public void onResponse(final AsyncSearchResponse searchResponse) {
                if (searchResponse.isRunning() || request.isKeepOnCompletion()) {
                    try {
                        String docId = searchTask.getExecutionId().getDocId();
                        AsyncSearchResponse initialResp = searchResponse.clone(searchResponse.getId());
                        TransportSubmitAsyncSearchAction.this.store.createResponse(docId, searchTask.getOriginHeaders(), (AsyncResponse)initialResp, (ActionListener)new ActionListener<IndexResponse>(){

                            public void onResponse(IndexResponse r) {
                                if (searchResponse.isRunning()) {
                                    try {
                                        searchTask.addCompletionListener(finalResponse -> TransportSubmitAsyncSearchAction.this.onFinalResponse(searchTask, finalResponse, () -> {}));
                                    }
                                    finally {
                                        submitListener.onResponse((Object)searchResponse);
                                    }
                                } else {
                                    TransportSubmitAsyncSearchAction.this.onFinalResponse(searchTask, searchResponse, () -> submitListener.onResponse((Object)searchResponse));
                                }
                            }

                            public void onFailure(Exception exc) {
                                TransportSubmitAsyncSearchAction.this.onFatalFailure(searchTask, exc, searchResponse.isRunning(), "fatal failure: unable to store initial response", (ActionListener<AsyncSearchResponse>)submitListener);
                            }
                        });
                    }
                    catch (Exception exc) {
                        TransportSubmitAsyncSearchAction.this.onFatalFailure(searchTask, exc, searchResponse.isRunning(), "fatal failure: generic error", (ActionListener<AsyncSearchResponse>)submitListener);
                    }
                } else {
                    TransportSubmitAsyncSearchAction.this.taskManager.unregister((Task)searchTask);
                    submitListener.onResponse((Object)searchResponse.clone(null));
                }
            }

            public void onFailure(Exception exc) {
                TransportSubmitAsyncSearchAction.this.onFatalFailure(searchTask, exc, true, "fatal failure: addCompletionListener", (ActionListener<AsyncSearchResponse>)submitListener);
            }
        }, request.getWaitForCompletionTimeout());
    }

    private SearchRequest createSearchRequest(final SubmitAsyncSearchRequest request, Task submitTask, final TimeValue keepAlive) {
        final String docID = UUIDs.randomBase64UUID();
        final Map originHeaders = this.nodeClient.threadPool().getThreadContext().getHeaders();
        SearchRequest searchRequest = new SearchRequest(request.getSearchRequest()){

            public AsyncSearchTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> taskHeaders) {
                AsyncExecutionId searchId = new AsyncExecutionId(docID, new TaskId(TransportSubmitAsyncSearchAction.this.nodeClient.getLocalNodeId(), id));
                Supplier<InternalAggregation.ReduceContext> aggReduceContextSupplier = () -> (InternalAggregation.ReduceContext)TransportSubmitAsyncSearchAction.this.requestToAggReduceContextBuilder.apply(request.getSearchRequest());
                return new AsyncSearchTask(id, type, action, parentTaskId, keepAlive, originHeaders, taskHeaders, searchId, TransportSubmitAsyncSearchAction.this.store.getClient(), TransportSubmitAsyncSearchAction.this.nodeClient.threadPool(), aggReduceContextSupplier);
            }
        };
        searchRequest.setParentTask(new TaskId(this.nodeClient.getLocalNodeId(), submitTask.getId()));
        return searchRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFatalFailure(AsyncSearchTask task, Exception error, boolean shouldCancel, String cancelReason, ActionListener<AsyncSearchResponse> listener) {
        if (shouldCancel && !task.isCancelled()) {
            task.cancelTask(() -> {
                try {
                    task.addCompletionListener(finalResponse -> this.taskManager.unregister((Task)task));
                }
                finally {
                    listener.onFailure(error);
                }
            }, cancelReason);
        } else {
            try {
                task.addCompletionListener(finalResponse -> this.taskManager.unregister((Task)task));
            }
            finally {
                listener.onFailure(error);
            }
        }
    }

    private void onFinalResponse(AsyncSearchTask searchTask, AsyncSearchResponse response, Runnable nextAction) {
        this.store.updateResponse(searchTask.getExecutionId().getDocId(), this.threadContext.getResponseHeaders(), (AsyncResponse)response, ActionListener.wrap(resp -> this.unregisterTaskAndMoveOn(searchTask, nextAction), exc -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exc);
            if (!(cause instanceof DocumentMissingException) && !(cause instanceof VersionConflictEngineException)) {
                logger.error(() -> new ParameterizedMessage("failed to store async-search [{}]", (Object)searchTask.getExecutionId().getEncoded()), (Throwable)exc);
            }
            this.unregisterTaskAndMoveOn(searchTask, nextAction);
        }));
    }

    private void unregisterTaskAndMoveOn(SearchTask searchTask, Runnable nextAction) {
        this.taskManager.unregister((Task)searchTask);
        nextAction.run();
    }
}

