/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.nio.BytesWriteHandler;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.Page;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.InboundPipeline;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.nio.NioTcpChannel;

public class TcpReadWriteHandler
extends BytesWriteHandler {
    private final NioTcpChannel channel;
    private final InboundPipeline pipeline;

    public TcpReadWriteHandler(NioTcpChannel channel, PageCacheRecycler recycler, TcpTransport transport) {
        this.channel = channel;
        ThreadPool threadPool = transport.getThreadPool();
        Supplier breaker = transport.getInflightBreaker();
        Transport.RequestHandlers requestHandlers = transport.getRequestHandlers();
        this.pipeline = new InboundPipeline(transport.getVersion(), transport.getStatsTracker(), recycler, () -> ((ThreadPool)threadPool).relativeTimeInMillis(), breaker, arg_0 -> ((Transport.RequestHandlers)requestHandlers).getHandler(arg_0), (arg_0, arg_1) -> ((TcpTransport)transport).inboundMessage(arg_0, arg_1));
    }

    public int consumeReads(InboundChannelBuffer channelBuffer) throws IOException {
        Page[] pages = channelBuffer.sliceAndRetainPagesTo(channelBuffer.getIndex());
        BytesReference[] references = new BytesReference[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            references[i] = BytesReference.fromByteBuffer((ByteBuffer)pages[i].byteBuffer());
        }
        Releasable releasable = () -> IOUtils.closeWhileHandlingException((Closeable[])pages);
        try (ReleasableBytesReference reference = new ReleasableBytesReference(CompositeBytesReference.of((BytesReference[])references), releasable);){
            this.pipeline.handleBytes((TcpChannel)this.channel, reference);
            int n = reference.length();
            return n;
        }
    }

    public void close() {
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.pipeline});
        super.close();
    }
}

