/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.container;

import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.sql.querydsl.container.FieldReference;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class SearchHitFieldRef
extends FieldReference {
    private final String name;
    private final String fullFieldName;
    private final DataType dataType;
    private final boolean docValue;
    private final String hitName;

    public SearchHitFieldRef(String name, String fullFieldName, DataType dataType, boolean useDocValueInsteadOfSource, boolean isAlias) {
        this(name, fullFieldName, dataType, useDocValueInsteadOfSource, isAlias, null);
    }

    public SearchHitFieldRef(String name, String fullFieldName, DataType dataType, boolean useDocValueInsteadOfSource, boolean isAlias, String hitName) {
        this.name = name;
        this.fullFieldName = fullFieldName;
        this.dataType = dataType;
        this.docValue = isAlias ? useDocValueInsteadOfSource : (SqlDataTypes.isFromDocValuesOnly(dataType) ? useDocValueInsteadOfSource : false);
        this.hitName = hitName;
    }

    public String hitName() {
        return this.hitName;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String fullFieldName() {
        return this.fullFieldName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean useDocValue() {
        return this.docValue;
    }

    public void collectFields(QlSourceBuilder sourceBuilder) {
        if (this.hitName != null) {
            return;
        }
        if (this.docValue) {
            sourceBuilder.addDocField(this.name, SqlDataTypes.format(this.dataType));
        } else {
            sourceBuilder.addSourceField(this.name);
        }
    }

    public String toString() {
        return this.name;
    }
}

