/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.action.BasicFormatter;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.plugin.TextFormatterCursor;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Cursors;
import org.elasticsearch.xpack.sql.util.DateUtils;

enum TextFormat {
    PLAIN_TEXT{

        @Override
        String format(RestRequest request, SqlQueryResponse response) {
            BasicFormatter formatter = null;
            Cursor cursor = null;
            ZoneId zoneId = null;
            if (response.hasCursor()) {
                Tuple<Cursor, ZoneId> tuple = Cursors.decodeFromStringWithZone(response.cursor());
                cursor = (Cursor)tuple.v1();
                zoneId = (ZoneId)tuple.v2();
                if (cursor instanceof TextFormatterCursor) {
                    formatter = ((TextFormatterCursor)cursor).getFormatter();
                }
            }
            if (response.columns() != null) {
                formatter = new BasicFormatter(response.columns(), response.rows(), BasicFormatter.FormatOption.TEXT);
                if (cursor != null) {
                    response.cursor(Cursors.encodeToString(new TextFormatterCursor(cursor, formatter), zoneId));
                }
                return formatter.formatWithHeader(response.columns(), response.rows());
            }
            if (formatter != null) {
                return formatter.formatWithoutHeader(response.rows());
            }
            throw new SqlIllegalArgumentException("Cannot find text formatter - this is likely a bug");
        }

        @Override
        String shortName() {
            return "txt";
        }

        @Override
        String contentType() {
            return "text/plain";
        }

        @Override
        protected String delimiter() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String eol() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CSV{

        @Override
        protected String delimiter() {
            return ",";
        }

        @Override
        protected String eol() {
            return "\r\n";
        }

        @Override
        String shortName() {
            return "csv";
        }

        @Override
        String contentType() {
            return "text/csv";
        }

        @Override
        String contentType(RestRequest request) {
            return this.contentType() + "; charset=utf-8; header=" + (this.hasHeader(request) ? "present" : "absent");
        }

        @Override
        String maybeEscape(String value) {
            boolean needsEscaping = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c != '\"' && c != ',' && c != '\n' && c != '\r') continue;
                needsEscaping = true;
                break;
            }
            if (needsEscaping) {
                StringBuilder sb = new StringBuilder();
                sb.append('\"');
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (value.charAt(i) == '\"') {
                        sb.append('\"');
                    }
                    sb.append(c);
                }
                sb.append('\"');
                value = sb.toString();
            }
            return value;
        }

        @Override
        boolean hasHeader(RestRequest request) {
            String header = request.param("header");
            if (header == null) {
                List values = request.getAllHeaderValues("Accept");
                if (values != null) {
                    for (String value : values) {
                        String[] params;
                        for (String param : params = Strings.tokenizeToStringArray((String)value, (String)";")) {
                            if (!param.toLowerCase(Locale.ROOT).equals("header=absent")) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return !header.toLowerCase(Locale.ROOT).equals("absent");
        }
    }
    ,
    TSV{

        @Override
        protected String delimiter() {
            return "\t";
        }

        @Override
        protected String eol() {
            return "\n";
        }

        @Override
        String shortName() {
            return "tsv";
        }

        @Override
        String contentType() {
            return "text/tab-separated-values";
        }

        @Override
        String contentType(RestRequest request) {
            return this.contentType() + "; charset=utf-8";
        }

        @Override
        String maybeEscape(String value) {
            StringBuilder sb = new StringBuilder();
            block4: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        continue block4;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block4;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    };


    String format(RestRequest request, SqlQueryResponse response) {
        StringBuilder sb = new StringBuilder();
        if (this.hasHeader(request) && response.columns() != null) {
            this.row(sb, response.columns(), ColumnInfo::name);
        }
        for (List row : response.rows()) {
            this.row(sb, row, f -> f instanceof ZonedDateTime ? DateUtils.toString((ZonedDateTime)f) : Objects.toString(f, ""));
        }
        return sb.toString();
    }

    boolean hasHeader(RestRequest request) {
        return true;
    }

    static TextFormat fromMediaTypeOrFormat(String accept) {
        for (TextFormat text : TextFormat.values()) {
            String contentType = text.contentType();
            if (!contentType.equalsIgnoreCase(accept) && !accept.toLowerCase(Locale.ROOT).startsWith(contentType + ";") && !text.shortName().equalsIgnoreCase(accept)) continue;
            return text;
        }
        throw new IllegalArgumentException("invalid format [" + accept + "]");
    }

    abstract String shortName();

    abstract String contentType();

    String contentType(RestRequest request) {
        return this.contentType();
    }

    <F> void row(StringBuilder sb, List<F> row, Function<F, String> toString) {
        for (int i = 0; i < row.size(); ++i) {
            sb.append(this.maybeEscape(toString.apply(row.get(i))));
            if (i >= row.size() - 1) continue;
            sb.append(this.delimiter());
        }
        sb.append(this.eol());
    }

    protected abstract String delimiter();

    protected abstract String eol();

    String maybeEscape(String value) {
        return value;
    }
}

