/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.util.ReflectionUtils;
import org.elasticsearch.xpack.sql.plan.logical.Join;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.With;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.sql.plan.physical.CommandExec;
import org.elasticsearch.xpack.sql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.sql.plan.physical.FilterExec;
import org.elasticsearch.xpack.sql.plan.physical.LimitExec;
import org.elasticsearch.xpack.sql.plan.physical.LocalExec;
import org.elasticsearch.xpack.sql.plan.physical.OrderExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.PivotExec;
import org.elasticsearch.xpack.sql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.sql.plan.physical.UnplannedExec;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;

class Mapper
extends RuleExecutor<PhysicalPlan> {
    Mapper() {
    }

    public PhysicalPlan map(LogicalPlan plan) {
        return (PhysicalPlan)this.execute((Node)Mapper.planLater(plan));
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch conversion = new RuleExecutor.Batch((RuleExecutor)this, "Mapping", new Rule[]{new JoinMapper(), new SimpleExecMapper()});
        return Arrays.asList(conversion);
    }

    private static PhysicalPlan planLater(LogicalPlan plan) {
        return new UnplannedExec(plan.source(), plan);
    }

    private static class JoinMapper
    extends MapExecRule<Join> {
        private JoinMapper() {
        }

        @Override
        protected PhysicalPlan map(Join j) {
            return this.join(j);
        }

        private PhysicalPlan join(Join join) {
            throw new UnsupportedOperationException("Don't know how to handle join " + join.nodeString());
        }
    }

    private static class SimpleExecMapper
    extends MapExecRule<LogicalPlan> {
        private SimpleExecMapper() {
        }

        @Override
        protected PhysicalPlan map(LogicalPlan p) {
            if (p instanceof Command) {
                return new CommandExec(p.source(), (Command)p);
            }
            if (p instanceof LocalRelation) {
                return new LocalExec(p.source(), ((LocalRelation)p).executable());
            }
            if (p instanceof Project) {
                Project pj = (Project)p;
                return new ProjectExec(p.source(), this.map(pj.child()), pj.projections());
            }
            if (p instanceof Filter) {
                Filter fl = (Filter)p;
                return new FilterExec(p.source(), this.map(fl.child()), fl.condition());
            }
            if (p instanceof OrderBy) {
                OrderBy o = (OrderBy)p;
                return new OrderExec(p.source(), this.map(o.child()), o.order());
            }
            if (p instanceof Aggregate) {
                Aggregate a = (Aggregate)p;
                return new AggregateExec(p.source(), this.map(a.child()), a.groupings(), a.aggregates());
            }
            if (p instanceof Pivot) {
                Pivot pv = (Pivot)p;
                return new PivotExec(pv.source(), this.map(pv.child()), pv);
            }
            if (p instanceof EsRelation) {
                EsRelation c = (EsRelation)p;
                List output = c.output();
                QueryContainer container = new QueryContainer();
                if (c.frozen()) {
                    container = container.withFrozen();
                }
                return new EsQueryExec(p.source(), c.index().name(), output, container);
            }
            if (p instanceof Limit) {
                Limit l = (Limit)p;
                return new LimitExec(p.source(), this.map(l.child()), l.limit());
            }
            if (p instanceof With) {
                throw new UnsupportedOperationException("With should have been translated already");
            }
            return Mapper.planLater(p);
        }
    }

    static abstract class MapExecRule<SubPlan extends LogicalPlan>
    extends Rule<UnplannedExec, PhysicalPlan> {
        private final Class<SubPlan> subPlanToken = ReflectionUtils.detectSuperTypeForRuleLike(((Object)((Object)this)).getClass());

        MapExecRule() {
        }

        public final PhysicalPlan apply(PhysicalPlan plan) {
            return (PhysicalPlan)plan.transformUp(this::rule, UnplannedExec.class);
        }

        protected final PhysicalPlan rule(UnplannedExec plan) {
            LogicalPlan subPlan = plan.plan();
            if (this.subPlanToken.isInstance(subPlan)) {
                return this.map(subPlan);
            }
            return plan;
        }

        protected abstract PhysicalPlan map(SubPlan var1);
    }
}

