/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.ExpressionSet;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.CompoundAggregate;
import org.elasticsearch.xpack.ql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.ql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.analysis.analyzer.Analyzer;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStatsEnclosed;
import org.elasticsearch.xpack.sql.expression.function.aggregate.First;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Last;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStatsEnclosed;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRank;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRanks;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentiles;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Stats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ArbitraryConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Coalesce;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Iif;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.session.EmptyExecutable;
import org.elasticsearch.xpack.sql.session.SingletonExecutable;

public class Optimizer
extends RuleExecutor<LogicalPlan> {
    public RuleExecutor.ExecutionInfo debugOptimize(LogicalPlan verified) {
        return verified.optimized() ? null : this.executeWithInfo((Node)verified);
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        return verified.optimized() ? verified : (LogicalPlan)this.execute((Node)verified);
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch pivot = new RuleExecutor.Batch((RuleExecutor)this, "Pivot Rewrite", RuleExecutor.Limiter.ONCE, new Rule[]{new RewritePivot()});
        RuleExecutor.Batch refs = new RuleExecutor.Batch((RuleExecutor)this, "Replace References", RuleExecutor.Limiter.ONCE, new Rule[]{new ReplaceReferenceAttributeWithSource(), new ReplaceAggregatesWithLiterals(), new ReplaceCountInLocalRelation()});
        RuleExecutor.Batch operators = new RuleExecutor.Batch((RuleExecutor)this, "Operator Optimization", new Rule[]{new CombineProjections(), new ReplaceFoldableAttributes(), new FoldNull(), new OptimizerRules.ConstantFolding(), new SimplifyConditional(), new SimplifyCase(), new OptimizerRules.BooleanSimplification(), new OptimizerRules.BooleanLiteralsOnTheRight(), new BinaryComparisonSimplification(), new OptimizerRules.PropagateEquals(), new OptimizerRules.CombineBinaryComparisons(), new PruneLiteralsInGroupBy(), new PruneDuplicatesInGroupBy(), new PruneFilters(), new PruneOrderByForImplicitGrouping(), new OptimizerRules.PruneLiteralsInOrderBy(), new PruneOrderByNestedFields(), new PruneCast(), new SortAggregateOnOrderBy()});
        RuleExecutor.Batch aggregate = new RuleExecutor.Batch((RuleExecutor)this, "Aggregation Rewrite", new Rule[]{new ReplaceMinMaxWithTopHits(), new ReplaceAggsWithMatrixStats(), new ReplaceAggsWithExtendedStats(), new ReplaceAggsWithStats(), new PromoteStatsToExtendedStats(), new ReplaceAggsWithPercentiles(), new ReplaceAggsWithPercentileRanks()});
        RuleExecutor.Batch local = new RuleExecutor.Batch((RuleExecutor)this, "Skip Elasticsearch", new Rule[]{new SkipQueryOnLimitZero(), new SkipQueryIfFoldingProjection()});
        RuleExecutor.Batch label = new RuleExecutor.Batch((RuleExecutor)this, "Set as Optimized", RuleExecutor.Limiter.ONCE, new Rule[]{Analyzer.CleanAliases.INSTANCE, new OptimizerRules.SetAsOptimized()});
        return Arrays.asList(pivot, refs, operators, aggregate, local, label);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan) {
        return new LocalRelation(plan.source(), new EmptyExecutable(plan.output()));
    }

    static class RewritePivot
    extends OptimizerRules.OptimizerRule<Pivot> {
        RewritePivot() {
        }

        protected LogicalPlan rule(Pivot plan) {
            ArrayList<Expression> rawValues = new ArrayList<Expression>(plan.values().size());
            for (NamedExpression namedExpression : plan.values()) {
                if (namedExpression instanceof Alias) {
                    rawValues.add((Expression)Literal.of((Expression)((Alias)namedExpression).child()));
                    continue;
                }
                UnresolvedAttribute attr = new UnresolvedAttribute(namedExpression.source(), namedExpression.name(), null, "Unexpected alias");
                return new Pivot(plan.source(), plan.child(), plan.column(), Collections.singletonList(attr), plan.aggregates());
            }
            Filter filter = new Filter(plan.source(), plan.child(), (Expression)new In(plan.source(), plan.column(), rawValues));
            return new Pivot(plan.source(), (LogicalPlan)filter, plan.column(), plan.values(), plan.aggregates(), plan.groupings());
        }
    }

    static class ReplaceReferenceAttributeWithSource
    extends OptimizerBasicRule {
        ReplaceReferenceAttributeWithSource() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            LinkedHashMap collectRefs = new LinkedHashMap();
            plan.forEachUp(p -> p.forEachExpressionsUp(e -> {
                if (e instanceof Alias) {
                    Alias a = (Alias)e;
                    collectRefs.put(a.toAttribute(), a.child());
                }
            }));
            plan = (LogicalPlan)plan.transformUp(p -> {
                if (!(p instanceof Pivot || p instanceof Aggregate || p instanceof Project) || p.children().isEmpty()) {
                    p = (LogicalPlan)p.transformExpressionsOnly(e -> {
                        if (e instanceof ReferenceAttribute) {
                            e = collectRefs.getOrDefault(e, e);
                        }
                        return e;
                    });
                }
                return p;
            });
            return plan;
        }
    }

    private static class ReplaceAggregatesWithLiterals
    extends OptimizerRules.OptimizerRule<LogicalPlan> {
        private ReplaceAggregatesWithLiterals() {
        }

        protected LogicalPlan rule(LogicalPlan p) {
            return (LogicalPlan)p.transformExpressionsDown(e -> {
                AggregateFunction a;
                if ((e instanceof Min || e instanceof Max || e instanceof Avg || e instanceof Sum || e instanceof Count && ((Count)e).distinct()) && (a = (AggregateFunction)e).field().foldable()) {
                    Count countOne = new Count(a.source(), (Expression)new Literal(Source.EMPTY, (Object)1, a.dataType()), false);
                    Equals countEqZero = new Equals(a.source(), (Expression)countOne, (Expression)new Literal(Source.EMPTY, (Object)0, a.dataType()));
                    Expression argument = a.field();
                    Literal foldedArgument = new Literal(argument.source(), argument.fold(), a.dataType());
                    Literal iifResult = Literal.NULL;
                    Object iifElseResult = foldedArgument;
                    if (e instanceof Sum) {
                        iifElseResult = new Mul(a.source(), (Expression)countOne, (Expression)foldedArgument);
                    } else if (e instanceof Count) {
                        iifResult = new Literal(Source.EMPTY, (Object)0, e.dataType());
                        iifElseResult = new Literal(Source.EMPTY, (Object)1, e.dataType());
                    }
                    return new Iif(a.source(), (Expression)countEqZero, (Expression)iifResult, (Expression)iifElseResult);
                }
                return e;
            });
        }
    }

    private static class ReplaceCountInLocalRelation
    extends OptimizerRules.OptimizerRule<Aggregate> {
        private ReplaceCountInLocalRelation() {
        }

        protected LogicalPlan rule(Aggregate a) {
            boolean hasLocalRelation = a.anyMatch(LocalRelation.class::isInstance);
            return hasLocalRelation ? (LogicalPlan)a.transformExpressionsDown(c -> c instanceof Count ? new Literal(c.source(), (Object)1, c.dataType()) : c) : a;
        }
    }

    static class CombineProjections
    extends OptimizerRules.OptimizerRule<Project> {
        CombineProjections() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(Project project) {
            LogicalPlan child = project.child();
            if (child instanceof Project) {
                Project p = (Project)child;
                return new Project(p.source(), p.child(), this.combineProjections(project.projections(), p.projections()));
            }
            if (child instanceof Aggregate) {
                Aggregate a = (Aggregate)child;
                return new Aggregate(a.source(), a.child(), a.groupings(), this.combineProjections(project.projections(), a.aggregates()));
            }
            if (child instanceof Pivot) {
                Pivot p = (Pivot)child;
                if (project.outputSet().subsetOf(p.groupingSet())) {
                    return new Aggregate(p.source(), p.child(), new ArrayList(project.projections()), project.projections());
                }
            }
            return project;
        }

        private List<NamedExpression> combineProjections(List<? extends NamedExpression> upper, List<? extends NamedExpression> lower) {
            LinkedHashMap<Attribute, NamedExpression> map = new LinkedHashMap<Attribute, NamedExpression>();
            for (NamedExpression namedExpression : lower) {
                if (namedExpression instanceof Attribute) continue;
                map.put(namedExpression.toAttribute(), namedExpression);
            }
            AttributeMap aliases = new AttributeMap(map);
            ArrayList<NamedExpression> arrayList = new ArrayList<NamedExpression>();
            for (NamedExpression namedExpression : upper) {
                NamedExpression replacedExp = (NamedExpression)namedExpression.transformUp(a -> {
                    NamedExpression as = (NamedExpression)aliases.get(a);
                    return as != null ? as : a;
                }, Attribute.class);
                arrayList.add((NamedExpression)Analyzer.CleanAliases.trimNonTopLevelAliases((Expression)replacedExp));
            }
            return arrayList;
        }
    }

    static class ReplaceFoldableAttributes
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceFoldableAttributes() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            return this.rule(plan);
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            LinkedHashMap aliases = new LinkedHashMap();
            ArrayList attrs = new ArrayList();
            plan.forEachDown(p -> {
                for (NamedExpression ne : p.projections()) {
                    if (!(ne instanceof Alias) || !((Alias)ne).child().foldable()) continue;
                    Attribute attr = ne.toAttribute();
                    attrs.add(attr);
                    aliases.put(attr, (Alias)ne);
                }
            }, Project.class);
            if (attrs.isEmpty()) {
                return plan;
            }
            Holder stop = new Holder((Object)Boolean.FALSE);
            plan = (LogicalPlan)plan.transformUp(p -> {
                if (stop.get() == Boolean.FALSE && this.canPropagateFoldable((LogicalPlan)p)) {
                    return (LogicalPlan)p.transformExpressionsDown(e -> {
                        if (e instanceof Attribute && attrs.contains(e)) {
                            Alias as = (Alias)aliases.get(e);
                            if (as == null) {
                                throw new SqlIllegalArgumentException("unsupported");
                            }
                            return as;
                        }
                        return e;
                    });
                }
                if (p.children().size() > 1) {
                    stop.set((Object)Boolean.TRUE);
                }
                return p;
            });
            return Analyzer.CleanAliases.INSTANCE.apply(plan);
        }

        private boolean canPropagateFoldable(LogicalPlan p) {
            return p instanceof Project || p instanceof Filter || p instanceof SubQueryAlias || p instanceof Aggregate || p instanceof Limit || p instanceof OrderBy;
        }
    }

    static class FoldNull
    extends OptimizerRules.OptimizerExpressionRule {
        FoldNull() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected Expression rule(Expression e) {
            if (e instanceof IsNotNull) {
                if (((IsNotNull)e).field().nullable() == Nullability.FALSE) {
                    return new Literal(e.source(), (Object)Boolean.TRUE, DataTypes.BOOLEAN);
                }
            } else if (e instanceof IsNull) {
                if (((IsNull)e).field().nullable() == Nullability.FALSE) {
                    return new Literal(e.source(), (Object)Boolean.FALSE, DataTypes.BOOLEAN);
                }
            } else if (e instanceof In) {
                In in = (In)e;
                if (Expressions.isNull((Expression)in.value())) {
                    return Literal.of((Expression)in, null);
                }
            } else if (!(e instanceof Alias) && e.nullable() == Nullability.TRUE && Expressions.anyMatch((List)e.children(), Expressions::isNull)) {
                return Literal.of((Expression)e, null);
            }
            return e;
        }
    }

    static class SimplifyConditional
    extends OptimizerRules.OptimizerExpressionRule {
        SimplifyConditional() {
            super(OptimizerRules.TransformDirection.DOWN);
        }

        protected Expression rule(Expression e) {
            if (e instanceof ArbitraryConditionalFunction) {
                ArbitraryConditionalFunction c = (ArbitraryConditionalFunction)e;
                ArrayList<Expression> newChildren = new ArrayList<Expression>();
                for (Expression child : c.children()) {
                    if (Expressions.isNull((Expression)child)) continue;
                    newChildren.add(child);
                    if (!(e instanceof Coalesce) || !child.foldable()) continue;
                    break;
                }
                if (newChildren.size() < c.children().size()) {
                    return (Expression)c.replaceChildren(newChildren);
                }
            }
            return e;
        }
    }

    static class SimplifyCase
    extends OptimizerRules.OptimizerExpressionRule {
        SimplifyCase() {
            super(OptimizerRules.TransformDirection.DOWN);
        }

        protected Expression rule(Expression e) {
            if (e instanceof Case) {
                Case c = (Case)e;
                ArrayList<IfConditional> newConditions = new ArrayList<IfConditional>();
                for (IfConditional conditional : c.conditions()) {
                    if (conditional.condition().foldable()) {
                        Boolean res = (Boolean)conditional.condition().fold();
                        if (res != Boolean.TRUE) continue;
                        newConditions.add(conditional);
                        break;
                    }
                    newConditions.add(conditional);
                }
                if (newConditions.size() < c.children().size()) {
                    return c.replaceChildren((List<Expression>)CollectionUtils.combine(newConditions, (Object[])new Expression[]{c.elseResult()}));
                }
            }
            return e;
        }
    }

    static class BinaryComparisonSimplification
    extends OptimizerRules.OptimizerExpressionRule {
        BinaryComparisonSimplification() {
            super(OptimizerRules.TransformDirection.DOWN);
        }

        protected Expression rule(Expression e) {
            return e instanceof BinaryComparison ? this.simplify((BinaryComparison)e) : e;
        }

        private Expression simplify(BinaryComparison bc) {
            Expression l = bc.left();
            Expression r = bc.right();
            if ((bc instanceof Equals || bc instanceof GreaterThanOrEqual || bc instanceof LessThanOrEqual) && l.nullable() == Nullability.FALSE && r.nullable() == Nullability.FALSE && l.semanticEquals(r)) {
                return new Literal(bc.source(), (Object)Boolean.TRUE, DataTypes.BOOLEAN);
            }
            if (bc instanceof NullEquals) {
                if (l.semanticEquals(r)) {
                    return new Literal(bc.source(), (Object)Boolean.TRUE, DataTypes.BOOLEAN);
                }
                if (Expressions.isNull((Expression)r)) {
                    return new IsNull(bc.source(), l);
                }
            }
            if ((bc instanceof NotEquals || bc instanceof GreaterThan || bc instanceof LessThan) && l.nullable() == Nullability.FALSE && r.nullable() == Nullability.FALSE && l.semanticEquals(r)) {
                return new Literal(bc.source(), (Object)Boolean.FALSE, DataTypes.BOOLEAN);
            }
            return bc;
        }
    }

    static class PruneLiteralsInGroupBy
    extends OptimizerRules.OptimizerRule<Aggregate> {
        PruneLiteralsInGroupBy() {
        }

        protected LogicalPlan rule(Aggregate agg) {
            List groupings = agg.groupings();
            ArrayList<Expression> prunedGroupings = new ArrayList<Expression>();
            for (Expression g : groupings) {
                if (!g.foldable()) continue;
                prunedGroupings.add(g);
            }
            if (prunedGroupings.size() > 0) {
                ArrayList newGroupings = new ArrayList(groupings);
                newGroupings.removeAll(prunedGroupings);
                return new Aggregate(agg.source(), agg.child(), newGroupings, agg.aggregates());
            }
            return agg;
        }
    }

    static class PruneDuplicatesInGroupBy
    extends OptimizerRules.OptimizerRule<Aggregate> {
        PruneDuplicatesInGroupBy() {
        }

        protected LogicalPlan rule(Aggregate agg) {
            List groupings = agg.groupings();
            if (groupings.isEmpty()) {
                return agg;
            }
            ExpressionSet unique = new ExpressionSet((Collection)groupings);
            if (unique.size() != groupings.size()) {
                return new Aggregate(agg.source(), agg.child(), new ArrayList(unique), agg.aggregates());
            }
            return agg;
        }
    }

    static class PruneFilters
    extends OptimizerRules.PruneFilters {
        PruneFilters() {
        }

        protected LogicalPlan skipPlan(Filter filter) {
            return Optimizer.skipPlan((UnaryPlan)filter);
        }
    }

    static class PruneOrderByForImplicitGrouping
    extends OptimizerRules.OptimizerRule<OrderBy> {
        PruneOrderByForImplicitGrouping() {
        }

        protected LogicalPlan rule(OrderBy ob) {
            Holder foundAggregate = new Holder((Object)Boolean.FALSE);
            Holder foundImplicitGroupBy = new Holder((Object)Boolean.FALSE);
            ob.forEachDown(a -> {
                if (foundAggregate.get() == Boolean.TRUE) {
                    return;
                }
                foundAggregate.set((Object)Boolean.TRUE);
                if (a.groupings().isEmpty()) {
                    foundImplicitGroupBy.set((Object)Boolean.TRUE);
                }
            }, Aggregate.class);
            if (foundImplicitGroupBy.get() == Boolean.TRUE) {
                return ob.child();
            }
            return ob;
        }
    }

    static class PruneOrderByNestedFields
    extends OptimizerRules.OptimizerRule<Project> {
        PruneOrderByNestedFields() {
        }

        private void findNested(Expression exp, AttributeMap<Function> functions, Consumer<FieldAttribute> onFind) {
            exp.forEachUp(e -> {
                FieldAttribute fa;
                Function f;
                if (e instanceof ReferenceAttribute && (f = (Function)functions.get(e)) != null) {
                    this.findNested((Expression)f, functions, onFind);
                }
                if (e instanceof FieldAttribute && (fa = (FieldAttribute)e).isNested()) {
                    onFind.accept(fa);
                }
            });
        }

        protected LogicalPlan rule(Project project) {
            if (project.child() instanceof OrderBy) {
                OrderBy ob = (OrderBy)project.child();
                LinkedHashMap collectRefs = new LinkedHashMap();
                project.forEachUp(p -> p.forEachExpressionsUp(e -> {
                    Alias a;
                    if (e instanceof Alias && (a = (Alias)e).child() instanceof Function) {
                        collectRefs.put(a.toAttribute(), (Function)a.child());
                    }
                }));
                AttributeMap functions = new AttributeMap(collectRefs);
                LinkedHashMap nestedOrders = new LinkedHashMap();
                for (Object order : ob.order()) {
                    this.findNested(order.child(), (AttributeMap<Function>)functions, arg_0 -> PruneOrderByNestedFields.lambda$rule$3(nestedOrders, (Order)order, arg_0));
                }
                if (nestedOrders.isEmpty()) {
                    return project;
                }
                ArrayList nestedTopFields = new ArrayList();
                for (Object ne : project.projections()) {
                    this.findNested((Expression)ne, (AttributeMap<Function>)functions, fa -> nestedTopFields.add(fa.nestedParent().name()));
                }
                ArrayList orders = new ArrayList(ob.order());
                if (nestedTopFields.isEmpty()) {
                    orders.removeAll(nestedOrders.values());
                } else {
                    for (Map.Entry entry : nestedOrders.entrySet()) {
                        String parent = (String)entry.getKey();
                        boolean shouldKeep = false;
                        for (String topParent : nestedTopFields) {
                            if (!topParent.startsWith(parent)) continue;
                            shouldKeep = true;
                            break;
                        }
                        if (shouldKeep) continue;
                        orders.remove(entry.getValue());
                    }
                }
                if (orders.isEmpty()) {
                    return new Project(project.source(), ob.child(), project.projections());
                }
                if (orders.size() != ob.order().size()) {
                    OrderBy newOrder = new OrderBy(ob.source(), ob.child(), orders);
                    return new Project(project.source(), (LogicalPlan)newOrder, project.projections());
                }
            }
            return project;
        }

        private static /* synthetic */ void lambda$rule$3(Map nestedOrders, Order order, FieldAttribute fa) {
            nestedOrders.put(fa.nestedParent().name(), order);
        }
    }

    static class PruneCast
    extends Rule<LogicalPlan, LogicalPlan> {
        PruneCast() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            return this.rule(plan);
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            LogicalPlan transformed = (LogicalPlan)plan.transformExpressionsUp(e -> {
                Cast c;
                if (e instanceof Cast && (c = (Cast)((Object)e)).from() == c.to()) {
                    return c.field();
                }
                return e;
            });
            return transformed;
        }
    }

    static class SortAggregateOnOrderBy
    extends OptimizerRules.OptimizerRule<OrderBy> {
        SortAggregateOnOrderBy() {
        }

        protected LogicalPlan rule(OrderBy ob) {
            List order = ob.order();
            LinkedList<Order> nonConstant = new LinkedList<Order>();
            for (int i = order.size() - 1; i >= 0; --i) {
                nonConstant.add((Order)order.get(i));
            }
            Holder foundAggregate = new Holder((Object)Boolean.FALSE);
            return (LogicalPlan)ob.transformDown(a -> {
                if (foundAggregate.get() == Boolean.TRUE) {
                    return a;
                }
                foundAggregate.set((Object)Boolean.TRUE);
                LinkedList<Expression> groupings = new LinkedList<Expression>(a.groupings());
                for (Order o : nonConstant) {
                    Expression fieldToOrder = o.child();
                    for (Expression group : a.groupings()) {
                        Holder isMatching = new Holder((Object)Boolean.FALSE);
                        if (Expressions.equalsAsAttribute((Expression)fieldToOrder, (Expression)group)) {
                            isMatching.set((Object)Boolean.TRUE);
                        } else {
                            a.aggregates().forEach(alias -> {
                                Expression child;
                                if (alias instanceof Alias && (Expressions.equalsAsAttribute((Expression)(child = ((Alias)alias).child()), (Expression)group) && (Expressions.equalsAsAttribute((Expression)alias, (Expression)fieldToOrder) || Expressions.equalsAsAttribute((Expression)child, (Expression)fieldToOrder)) || Expressions.equalsAsAttribute((Expression)alias, (Expression)group) && (Expressions.equalsAsAttribute((Expression)alias, (Expression)fieldToOrder) || Expressions.equalsAsAttribute((Expression)child, (Expression)fieldToOrder)))) {
                                    isMatching.set((Object)Boolean.TRUE);
                                }
                            });
                        }
                        if (!((Boolean)isMatching.get()).booleanValue()) continue;
                        groupings.remove(group);
                        groupings.add(0, group);
                    }
                }
                if (!groupings.equals(a.groupings())) {
                    return new Aggregate(a.source(), a.child(), groupings, a.aggregates());
                }
                return a;
            }, Aggregate.class);
        }
    }

    static class ReplaceMinMaxWithTopHits
    extends OptimizerRules.OptimizerRule<LogicalPlan> {
        ReplaceMinMaxWithTopHits() {
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            HashMap mins = new HashMap();
            HashMap maxs = new HashMap();
            return (LogicalPlan)plan.transformExpressionsDown(e -> {
                Max max;
                Min min;
                if (e instanceof Min && DataTypes.isString((DataType)(min = (Min)((Object)e)).field().dataType())) {
                    return (Expression)mins.computeIfAbsent(min.field(), k -> new First(min.source(), (Expression)k, null));
                }
                if (e instanceof Max && DataTypes.isString((DataType)(max = (Max)((Object)e)).field().dataType())) {
                    return (Expression)maxs.computeIfAbsent(max.field(), k -> new Last(max.source(), (Expression)k, null));
                }
                return e;
            });
        }
    }

    static class ReplaceAggsWithMatrixStats
    extends OptimizerBasicRule {
        ReplaceAggsWithMatrixStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            return (LogicalPlan)p.transformExpressionsUp(e -> {
                if (e instanceof MatrixStatsEnclosed) {
                    AggregateFunction f = (AggregateFunction)e;
                    Expression argument = f.field();
                    MatrixStats matrixStats = (MatrixStats)((Object)((Object)seen.get(argument)));
                    if (matrixStats == null) {
                        Source source = new Source(f.sourceLocation(), "MATRIX(" + argument.sourceText() + ")");
                        matrixStats = new MatrixStats(source, argument);
                        seen.put(argument, matrixStats);
                    }
                    InnerAggregate ia = new InnerAggregate(f.source(), f, (CompoundAggregate)matrixStats, argument);
                    return ia;
                }
                return e;
            });
        }
    }

    static class ReplaceAggsWithExtendedStats
    extends OptimizerBasicRule {
        ReplaceAggsWithExtendedStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            return (LogicalPlan)p.transformExpressionsUp(e -> {
                if (e instanceof ExtendedStatsEnclosed) {
                    AggregateFunction f = (AggregateFunction)e;
                    Expression argument = f.field();
                    ExtendedStats extendedStats = (ExtendedStats)((Object)((Object)seen.get(argument)));
                    if (extendedStats == null) {
                        Source source = new Source(f.sourceLocation(), "EXT_STATS(" + argument.sourceText() + ")");
                        extendedStats = new ExtendedStats(source, argument);
                        seen.put(argument, extendedStats);
                    }
                    InnerAggregate ia = new InnerAggregate(f, (CompoundAggregate)extendedStats);
                    return ia;
                }
                return e;
            });
        }
    }

    static class ReplaceAggsWithStats
    extends OptimizerBasicRule {
        ReplaceAggsWithStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap potentialPromotions = new LinkedHashMap();
            p.forEachExpressionsUp(e -> {
                if (Stats.isTypeCompatible(e)) {
                    AggregateFunction f = (AggregateFunction)e;
                    Expression argument = f.field();
                    Match match = (Match)potentialPromotions.get(argument);
                    if (match == null) {
                        Source source = new Source(f.sourceLocation(), "STATS(" + argument.sourceText() + ")");
                        match = new Match(new Stats(source, argument));
                        potentialPromotions.put(argument, match);
                    }
                    match.add(f.getClass());
                }
            });
            if (potentialPromotions.isEmpty()) {
                return p;
            }
            return (LogicalPlan)p.transformExpressionsUp(e -> {
                AggregateFunction f;
                Expression argument;
                Match match;
                if (Stats.isTypeCompatible(e) && (match = (Match)potentialPromotions.get(argument = (f = (AggregateFunction)e).field())) != null) {
                    return match.maybePromote(f);
                }
                return e;
            });
        }

        private static class Match {
            final Stats stats;
            private final Set<Class<? extends AggregateFunction>> functionTypes = new LinkedHashSet<Class<? extends AggregateFunction>>();
            private Map<Class<? extends AggregateFunction>, InnerAggregate> innerAggs = null;

            Match(Stats stats) {
                this.stats = stats;
            }

            public String toString() {
                return this.stats.toString();
            }

            public void add(Class<? extends AggregateFunction> aggType) {
                this.functionTypes.add(aggType);
            }

            public AggregateFunction maybePromote(AggregateFunction agg) {
                if (this.functionTypes.size() > 1) {
                    if (this.innerAggs == null) {
                        this.innerAggs = new LinkedHashMap<Class<? extends AggregateFunction>, InnerAggregate>();
                    }
                    return (AggregateFunction)this.innerAggs.computeIfAbsent(agg.getClass(), k -> new InnerAggregate(agg, (CompoundAggregate)this.stats));
                }
                return agg;
            }
        }
    }

    static class PromoteStatsToExtendedStats
    extends OptimizerBasicRule {
        PromoteStatsToExtendedStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            p.forEachExpressionsUp(e -> {
                InnerAggregate ia;
                if (e instanceof InnerAggregate && (ia = (InnerAggregate)e).outer() instanceof ExtendedStats) {
                    ExtendedStats extStats = (ExtendedStats)ia.outer();
                    seen.putIfAbsent(extStats.field(), extStats);
                }
            });
            return (LogicalPlan)p.transformExpressionsUp(e -> {
                Stats stats;
                ExtendedStats ext;
                InnerAggregate ia;
                if (e instanceof InnerAggregate && (ia = (InnerAggregate)e).outer() instanceof Stats && (ext = (ExtendedStats)((Object)((Object)seen.get((stats = (Stats)ia.outer()).field())))) != null && stats.field().equals((Object)ext.field())) {
                    return new InnerAggregate(ia.inner(), (CompoundAggregate)ext);
                }
                return e;
            });
        }
    }

    static class ReplaceAggsWithPercentiles
    extends OptimizerBasicRule {
        ReplaceAggsWithPercentiles() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap<Expression, Set> percentsPerField = new LinkedHashMap<Expression, Set>();
            p.forEachExpressionsUp(e -> {
                if (e instanceof Percentile) {
                    Percentile per = (Percentile)((Object)e);
                    Expression field = per.field();
                    LinkedHashSet<Expression> percentiles = (LinkedHashSet<Expression>)percentsPerField.get(field);
                    if (percentiles == null) {
                        percentiles = new LinkedHashSet<Expression>();
                        percentsPerField.put(field, percentiles);
                    }
                    percentiles.add(per.percent());
                }
            });
            LinkedHashMap percentilesPerField = new LinkedHashMap();
            percentsPerField.forEach((k, v) -> percentilesPerField.put(k, new Percentiles(((Expression)v.iterator().next()).source(), (Expression)k, (List<Expression>)new ArrayList<Expression>((Collection<Expression>)v))));
            return (LogicalPlan)p.transformExpressionsUp(e -> {
                if (e instanceof Percentile) {
                    Percentile per = (Percentile)((Object)e);
                    Percentiles percentiles = (Percentiles)((Object)((Object)percentilesPerField.get(per.field())));
                    return new InnerAggregate((AggregateFunction)per, (CompoundAggregate)percentiles);
                }
                return e;
            });
        }
    }

    static class ReplaceAggsWithPercentileRanks
    extends OptimizerBasicRule {
        ReplaceAggsWithPercentileRanks() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap<Expression, Set> percentPerField = new LinkedHashMap<Expression, Set>();
            p.forEachExpressionsUp(e -> {
                if (e instanceof PercentileRank) {
                    PercentileRank per = (PercentileRank)((Object)e);
                    Expression field = per.field();
                    LinkedHashSet<Expression> percentiles = (LinkedHashSet<Expression>)percentPerField.get(field);
                    if (percentiles == null) {
                        percentiles = new LinkedHashSet<Expression>();
                        percentPerField.put(field, percentiles);
                    }
                    percentiles.add(per.value());
                }
            });
            LinkedHashMap ranksPerField = new LinkedHashMap();
            percentPerField.forEach((k, v) -> ranksPerField.put(k, new PercentileRanks(((Expression)v.iterator().next()).source(), (Expression)k, (List<Expression>)new ArrayList<Expression>((Collection<Expression>)v))));
            return (LogicalPlan)p.transformExpressionsUp(e -> {
                if (e instanceof PercentileRank) {
                    PercentileRank per = (PercentileRank)((Object)e);
                    PercentileRanks ranks = (PercentileRanks)((Object)((Object)ranksPerField.get(per.field())));
                    return new InnerAggregate((AggregateFunction)per, (CompoundAggregate)ranks);
                }
                return e;
            });
        }
    }

    static class SkipQueryOnLimitZero
    extends OptimizerRules.SkipQueryOnLimitZero {
        SkipQueryOnLimitZero() {
        }

        protected LogicalPlan skipPlan(Limit limit) {
            return Optimizer.skipPlan((UnaryPlan)limit);
        }
    }

    static class SkipQueryIfFoldingProjection
    extends OptimizerRules.OptimizerRule<LogicalPlan> {
        SkipQueryIfFoldingProjection() {
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            Holder optimizedPlan = new Holder();
            plan.forEachDown(p -> {
                List<Object> values = this.extractConstants(p.projections());
                if (values.size() == p.projections().size() && !(p.child() instanceof EsRelation) && SkipQueryIfFoldingProjection.isNotQueryWithFromClauseAndFilterFoldedToFalse((UnaryPlan)p)) {
                    optimizedPlan.set((Object)new LocalRelation(p.source(), new SingletonExecutable(p.output(), values.toArray())));
                }
            }, Project.class);
            if (optimizedPlan.get() != null) {
                return (LogicalPlan)optimizedPlan.get();
            }
            plan.forEachDown(a -> {
                List<Object> values = this.extractConstants(a.aggregates());
                if (values.size() == a.aggregates().size() && a.groupings().isEmpty() && SkipQueryIfFoldingProjection.isNotQueryWithFromClauseAndFilterFoldedToFalse((UnaryPlan)a)) {
                    optimizedPlan.set((Object)new LocalRelation(a.source(), new SingletonExecutable(a.output(), values.toArray())));
                }
            }, Aggregate.class);
            if (optimizedPlan.get() != null) {
                return (LogicalPlan)optimizedPlan.get();
            }
            return plan;
        }

        private List<Object> extractConstants(List<? extends NamedExpression> named) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (NamedExpression namedExpression : named) {
                if (namedExpression instanceof Alias) {
                    Alias a = (Alias)namedExpression;
                    if (a.child().foldable()) {
                        values.add(a.child().fold());
                        continue;
                    }
                    return values;
                }
                if (namedExpression.foldable()) {
                    values.add(namedExpression.fold());
                    continue;
                }
                return values;
            }
            return values;
        }

        private static boolean isNotQueryWithFromClauseAndFilterFoldedToFalse(UnaryPlan plan) {
            return !(plan.child() instanceof LocalRelation) || plan.child() instanceof LocalRelation && !(((LocalRelation)plan.child()).executable() instanceof EmptyExecutable);
        }
    }

    static abstract class OptimizerBasicRule
    extends Rule<LogicalPlan, LogicalPlan> {
        OptimizerBasicRule() {
        }

        public abstract LogicalPlan apply(LogicalPlan var1);

        protected LogicalPlan rule(LogicalPlan plan) {
            return plan;
        }
    }

    static class CombineLimits
    extends OptimizerRules.OptimizerRule<Limit> {
        CombineLimits() {
        }

        protected LogicalPlan rule(Limit limit) {
            if (limit.child() instanceof Limit) {
                throw new UnsupportedOperationException("not implemented yet");
            }
            throw new UnsupportedOperationException("not implemented yet");
        }
    }
}

