/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryOptionalMathPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryOptionalMathProcessor;

public abstract class BinaryOptionalNumericFunction
extends ScalarFunction {
    private final Expression left;
    private final Expression right;

    public BinaryOptionalNumericFunction(Source source, Expression left, Expression right) {
        super(source, right != null ? Arrays.asList(left, right) : Arrays.asList(left));
        this.left = left;
        this.right = right;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.left, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.right == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isInteger((Expression)this.right, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
    }

    protected Pipe makePipe() {
        return new BinaryOptionalMathPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.left), this.right == null ? null : Expressions.pipe((Expression)this.right), this.operation());
    }

    protected abstract BinaryOptionalMathProcessor.BinaryOptionalMathOperation operation();

    public boolean foldable() {
        return this.left.foldable() && (this.right == null || this.right.foldable());
    }

    public Object fold() {
        return this.operation().apply((Number)this.left.fold(), this.right == null ? (Number)null : (Number)((Number)this.right.fold()));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (this.right() != null && newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        if (this.right() == null && newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return this.replacedChildrenInstance(newChildren);
    }

    protected abstract Expression replacedChildrenInstance(List<Expression> var1);

    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.left);
        ScriptTemplate rightScript = this.asScript((Expression)(this.right == null ? Literal.NULL : this.right));
        return this.asScriptFrom(leftScript, rightScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s)"), this.operation().name().toLowerCase(Locale.ROOT), leftScript.template(), rightScript.template()), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).build(), this.dataType());
    }

    public DataType dataType() {
        return this.left().dataType();
    }

    protected Expression left() {
        return this.left;
    }

    protected Expression right() {
        return this.right;
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.operation());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        BinaryOptionalNumericFunction other = (BinaryOptionalNumericFunction)((Object)obj);
        return Objects.equals(other.left(), this.left()) && Objects.equals(other.right(), this.right()) && Objects.equals(other.operation(), this.operation());
    }
}

