/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.SqlTypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.TimeProcessor;
import org.elasticsearch.xpack.sql.util.DateUtils;

public abstract class TimeFunction
extends DateTimeFunction {
    TimeFunction(Source source, Expression field, ZoneId zoneId, DateTimeProcessor.DateTimeExtractor extractor) {
        super(source, field, zoneId, extractor);
    }

    public static Integer dateTimeChrono(OffsetTime time, String tzId, String chronoName) {
        return TimeFunction.dateTimeChrono(DateUtils.asTimeAtZone(time, ZoneId.of(tzId)), ChronoField.valueOf(chronoName));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return SqlTypeResolutions.isDateOrTime(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    protected Processor makeProcessor() {
        return new TimeProcessor(this.extractor(), this.zoneId());
    }
}

