/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeProcessor;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class DateTimeParseProcessor
extends BinaryDateTimeProcessor {
    private final Parser parser;
    public static final String NAME = "dtparse";

    public DateTimeParseProcessor(Processor source1, Processor source2, ZoneId zoneId, Parser parser) {
        super(source1, source2, zoneId);
        this.parser = parser;
    }

    public DateTimeParseProcessor(StreamInput in) throws IOException {
        super(in);
        this.parser = (Parser)in.readEnum(Parser.class);
    }

    @Override
    public void doWrite(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.parser);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object timestamp, Object pattern) {
        return this.parser.parse(timestamp, pattern, this.zoneId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.parser});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DateTimeParseProcessor other = (DateTimeParseProcessor)((Object)obj);
        return super.equals((Object)other) && Objects.equals((Object)this.parser, (Object)other.parser);
    }

    public Parser parser() {
        return this.parser;
    }

    public static enum Parser {
        DATE_TIME("datetime", ZonedDateTime::from, LocalDateTime::from),
        TIME("time", OffsetTime::from, LocalTime::from);

        private final BiFunction<String, String, TemporalAccessor> parser;
        private final String parseType;

        private Parser(String parseType, TemporalQuery<?> ... queries) {
            this.parseType = parseType;
            this.parser = (timestampStr, pattern) -> DateTimeFormatter.ofPattern(pattern, Locale.ROOT).parseBest((CharSequence)timestampStr, queries);
        }

        public Object parse(Object timestamp, Object pattern, ZoneId zoneId) {
            if (timestamp == null || pattern == null) {
                return null;
            }
            if (!(timestamp instanceof String)) {
                throw new SqlIllegalArgumentException("A string is required; received [{}]", timestamp);
            }
            if (!(pattern instanceof String)) {
                throw new SqlIllegalArgumentException("A string is required; received [{}]", pattern);
            }
            if (((String)timestamp).isEmpty() || ((String)pattern).isEmpty()) {
                return null;
            }
            try {
                TemporalAccessor ta = this.parser.apply((String)timestamp, (String)pattern);
                return DateUtils.atTimeZone(ta, zoneId);
            }
            catch (IllegalArgumentException | DateTimeException e) {
                String msg = e.getMessage();
                if (msg.contains("Unable to convert parsed text using any of the specified queries")) {
                    msg = LoggerMessageFormat.format(null, (String)"Unable to convert parsed text into [{}]", (Object[])new Object[]{this.parseType});
                }
                throw new SqlIllegalArgumentException("Invalid {} string [{}] or pattern [{}] is received; {}", this.parseType, timestamp, pattern, msg);
            }
        }
    }
}

