/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeProcessor;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class DateTimeFormatProcessor
extends BinaryDateTimeProcessor {
    public static final String NAME = "dtformat";

    public DateTimeFormatProcessor(Processor source1, Processor source2, ZoneId zoneId) {
        super(source1, source2, zoneId);
    }

    public DateTimeFormatProcessor(StreamInput in) throws IOException {
        super(in);
    }

    public static Object process(Object timestamp, Object pattern, ZoneId zoneId) {
        if (timestamp == null || pattern == null) {
            return null;
        }
        if (!(pattern instanceof String)) {
            throw new SqlIllegalArgumentException("A string is required; received [{}]", pattern);
        }
        if (((String)pattern).isEmpty()) {
            return null;
        }
        if (!(timestamp instanceof ZonedDateTime) && !(timestamp instanceof OffsetTime)) {
            throw new SqlIllegalArgumentException("A date/datetime/time is required; received [{}]", timestamp);
        }
        Comparable<ChronoZonedDateTime<?>> ta = timestamp instanceof ZonedDateTime ? ((ZonedDateTime)timestamp).withZoneSameInstant(zoneId) : DateUtils.asTimeAtZone((OffsetTime)timestamp, zoneId);
        try {
            return DateTimeFormatter.ofPattern((String)pattern, Locale.ROOT).format((TemporalAccessor)((Object)ta));
        }
        catch (IllegalArgumentException | DateTimeException e) {
            throw new SqlIllegalArgumentException("Invalid pattern [{}] is received for formatting date/time [{}]; {}", pattern, timestamp, e.getMessage());
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object timestamp, Object pattern) {
        return DateTimeFormatProcessor.process(timestamp, pattern, this.zoneId());
    }
}

