/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.SqlTypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFormatPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFormatProcessor;

public class DateTimeFormat
extends BinaryDateTimeFunction {
    public DateTimeFormat(Source source, Expression timestamp, Expression pattern, ZoneId zoneId) {
        super(source, timestamp, pattern, zoneId);
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = SqlTypeResolutions.isDateOrTime(this.left(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isString((Expression)this.right(), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    protected BinaryScalarFunction replaceChildren(Expression timestamp, Expression pattern) {
        return new DateTimeFormat(this.source(), timestamp, pattern, this.zoneId());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateTimeFormat::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected String scriptMethodName() {
        return "dateTimeFormat";
    }

    public Object fold() {
        return DateTimeFormatProcessor.process(this.left().fold(), this.right().fold(), this.zoneId());
    }

    @Override
    protected Pipe createPipe(Pipe timestamp, Pipe pattern, ZoneId zoneId) {
        return new DateTimeFormatPipe(this.source(), (Expression)this, timestamp, pattern, zoneId);
    }
}

