/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.SqlTypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateDiffPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateDiffProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DatePart;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeField;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.QuarterProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.ThreeArgsDateTimeFunction;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class DateDiff
extends ThreeArgsDateTimeFunction {
    public DateDiff(Source source, Expression unit, Expression startTimestamp, Expression endTimestamp, ZoneId zoneId) {
        super(source, unit, startTimestamp, endTimestamp, zoneId);
    }

    protected Expression.TypeResolution resolveType() {
        String datePartValue;
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.first(), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.first().foldable() && (datePartValue = (String)this.first().fold()) != null && !this.resolveDateTimeField(datePartValue)) {
            List<String> similar = this.findSimilarDateTimeFields(datePartValue);
            if (similar.isEmpty()) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"first argument of [{}] must be one of {} or their aliases; found value [{}]", (Object[])new Object[]{this.sourceText(), this.validDateTimeFieldValues(), Expressions.name((Expression)this.first())}));
            }
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Unknown value [{}] for first argument of [{}]; did you mean {}?", (Object[])new Object[]{Expressions.name((Expression)this.first()), this.sourceText(), similar}));
        }
        resolution = SqlTypeResolutions.isDate(this.second(), this.sourceText(), Expressions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = SqlTypeResolutions.isDate(this.third(), this.sourceText(), Expressions.ParamOrdinal.THIRD);
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    @Override
    protected ThreeArgsDateTimeFunction replaceChildren(Expression newFirst, Expression newSecond, Expression newThird) {
        return new DateDiff(this.source(), newFirst, newSecond, newThird, this.zoneId());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateDiff::new, (Object)this.first(), (Object)this.second(), (Object)this.third(), (Object)this.zoneId());
    }

    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    @Override
    protected Pipe createPipe(Pipe unit, Pipe startTimestamp, Pipe endTimestamp, ZoneId zoneId) {
        return new DateDiffPipe(this.source(), (Expression)this, unit, startTimestamp, endTimestamp, zoneId);
    }

    @Override
    protected String scriptMethodName() {
        return "dateDiff";
    }

    public Object fold() {
        return DateDiffProcessor.process(this.first().fold(), this.second().fold(), this.third().fold(), this.zoneId());
    }

    @Override
    protected boolean resolveDateTimeField(String dateTimeField) {
        return Part.resolve(dateTimeField) != null;
    }

    @Override
    protected List<String> findSimilarDateTimeFields(String dateTimeField) {
        return Part.findSimilar(dateTimeField);
    }

    @Override
    protected List<String> validDateTimeFieldValues() {
        return Part.VALID_VALUES;
    }

    public static enum Part implements DateTimeField
    {
        YEAR((start, end) -> end.getYear() - start.getYear(), "years", "yyyy", "yy"),
        QUARTER((start, end) -> QuarterProcessor.quarter(end) - QuarterProcessor.quarter(start) + YEAR.diff((ZonedDateTime)start, (ZonedDateTime)end) * 4, "quarters", "qq", "q"),
        MONTH((start, end) -> Part.safeInt(end.getLong(ChronoField.PROLEPTIC_MONTH) - start.getLong(ChronoField.PROLEPTIC_MONTH)), "months", "mm", "m"),
        DAYOFYEAR((start, end) -> Part.safeInt(Part.diffInDays(start, end)), "dy", "y"),
        DAY(DAYOFYEAR::diff, "days", "dd", "d"),
        WEEK((start, end) -> {
            long startInDays = start.toInstant().toEpochMilli() / 86400000L - (long)DatePart.Part.WEEKDAY.extract(start.withZoneSameInstant(DateUtils.UTC)).intValue();
            long endInDays = end.toInstant().toEpochMilli() / 86400000L - (long)DatePart.Part.WEEKDAY.extract(end.withZoneSameInstant(DateUtils.UTC)).intValue();
            return Part.safeInt((endInDays - startInDays) / 7L);
        }, "weeks", "wk", "ww"),
        WEEKDAY(DAYOFYEAR::diff, "weekdays", "dw"),
        HOUR((start, end) -> Part.safeInt(Part.diffInHours(start, end)), "hours", "hh"),
        MINUTE((start, end) -> Part.safeInt(Part.diffInMinutes(start, end)), "minutes", "mi", "n"),
        SECOND((start, end) -> Part.safeInt(end.toEpochSecond() - start.toEpochSecond()), "seconds", "ss", "s"),
        MILLISECOND((start, end) -> Part.safeInt(end.toInstant().toEpochMilli() - start.toInstant().toEpochMilli()), "milliseconds", "ms"),
        MICROSECOND((start, end) -> {
            long secondsDiff = Part.diffInSeconds(start, end);
            long microsDiff = end.toInstant().getLong(ChronoField.MICRO_OF_SECOND) - start.toInstant().getLong(ChronoField.MICRO_OF_SECOND);
            return Part.safeInt(secondsDiff * 1000000L + microsDiff);
        }, "microseconds", "mcs"),
        NANOSECOND((start, end) -> {
            long secondsDiff = Part.diffInSeconds(start, end);
            int nanosDiff = end.getNano() - start.getNano();
            return Part.safeInt(secondsDiff * 1000000000L + (long)nanosDiff);
        }, "nanoseconds", "ns");

        private static final Map<String, Part> NAME_TO_PART;
        private static final List<String> VALID_VALUES;
        private BiFunction<ZonedDateTime, ZonedDateTime, Integer> diffFunction;
        private Set<String> aliases;

        private Part(BiFunction<ZonedDateTime, ZonedDateTime, Integer> diffFunction, String ... aliases) {
            this.diffFunction = diffFunction;
            this.aliases = new HashSet<String>(Arrays.asList(aliases));
        }

        @Override
        public Iterable<String> aliases() {
            return this.aliases;
        }

        public static List<String> findSimilar(String match) {
            return DateTimeField.findSimilar(NAME_TO_PART.keySet(), match);
        }

        public static Part resolve(String dateTimeUnit) {
            return DateTimeField.resolveMatch(NAME_TO_PART, dateTimeUnit);
        }

        public Integer diff(ZonedDateTime startTimestamp, ZonedDateTime endTimestamp) {
            return this.diffFunction.apply(startTimestamp, endTimestamp);
        }

        private static long diffInSeconds(ZonedDateTime start, ZonedDateTime end) {
            return end.toEpochSecond() - start.toEpochSecond();
        }

        private static int safeInt(long diff) {
            if (diff > Integer.MAX_VALUE || diff < Integer.MIN_VALUE) {
                throw new SqlIllegalArgumentException("The DATE_DIFF function resulted in an overflow; the number of units separating two date/datetime instances is too large. Try to use DATE_DIFF with a less precise unit.");
            }
            return Long.valueOf(diff).intValue();
        }

        private static long diffInMinutes(ZonedDateTime start, ZonedDateTime end) {
            return end.toEpochSecond() / 60L - start.toEpochSecond() / 60L;
        }

        private static long diffInHours(ZonedDateTime start, ZonedDateTime end) {
            return Part.diffInMinutes(start, end) / 60L;
        }

        private static long diffInDays(ZonedDateTime start, ZonedDateTime end) {
            return Part.diffInHours(start, end) / 24L;
        }

        static {
            NAME_TO_PART = DateTimeField.initializeResolutionMap((DateTimeField[])Part.values());
            VALID_VALUES = DateTimeField.initializeValidValues((DateTimeField[])Part.values());
        }
    }
}

