/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public final class SqlTypeResolutions {
    private SqlTypeResolutions() {
    }

    public static Expression.TypeResolution isDate(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, SqlDataTypes::isDateBased, (String)operationName, (Expressions.ParamOrdinal)paramOrd, (String[])new String[]{"date", "datetime"});
    }

    public static Expression.TypeResolution isDateOrTime(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, SqlDataTypes::isDateOrTimeBased, (String)operationName, (Expressions.ParamOrdinal)paramOrd, (String[])new String[]{"date", "time", "datetime"});
    }

    public static Expression.TypeResolution isDateOrInterval(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, SqlDataTypes::isDateOrIntervalBased, (String)operationName, (Expressions.ParamOrdinal)paramOrd, (String[])new String[]{"date", "datetime", "an interval data type"});
    }

    public static Expression.TypeResolution isNumericOrDate(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, dt -> dt.isNumeric() || SqlDataTypes.isDateBased(dt), (String)operationName, (Expressions.ParamOrdinal)paramOrd, (String[])new String[]{"date", "datetime", "numeric"});
    }

    public static Expression.TypeResolution isNumericOrDateOrTime(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, dt -> dt.isNumeric() || SqlDataTypes.isDateOrTimeBased(dt), (String)operationName, (Expressions.ParamOrdinal)paramOrd, (String[])new String[]{"date", "time", "datetime", "numeric"});
    }

    public static Expression.TypeResolution isGeo(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, SqlDataTypes::isGeo, (String)operationName, (Expressions.ParamOrdinal)paramOrd, (String[])new String[]{"geo_point", "geo_shape"});
    }
}

