/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAlias;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.Functions;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.sql.analysis.analyzer.VerificationException;
import org.elasticsearch.xpack.sql.analysis.analyzer.Verifier;
import org.elasticsearch.xpack.sql.expression.SubQueryExpression;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.plan.logical.Join;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.plan.logical.With;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;

public class Analyzer
extends RuleExecutor<LogicalPlan> {
    private final FunctionRegistry functionRegistry;
    private final IndexResolution indexResolution;
    private final Configuration configuration;
    private final Verifier verifier;

    public Analyzer(Configuration configuration, FunctionRegistry functionRegistry, IndexResolution results, Verifier verifier) {
        this.configuration = configuration;
        this.functionRegistry = functionRegistry;
        this.indexResolution = results;
        this.verifier = verifier;
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch substitution = new RuleExecutor.Batch((RuleExecutor)this, "Substitution", new Rule[]{new CTESubstitution()});
        RuleExecutor.Batch resolution = new RuleExecutor.Batch((RuleExecutor)this, "Resolution", new Rule[]{new ResolveTable(), new ResolveRefs(), new ResolveOrdinalInOrderByAndGroupBy(), new ResolveMissingRefs(), new ResolveFilterRefs(), new ResolveFunctions(), new ResolveAliases(), new ProjectedAggregations(), new HavingOverProject(), new ResolveAggsInHaving(), new ResolveAggsInOrderBy()});
        RuleExecutor.Batch finish = new RuleExecutor.Batch((RuleExecutor)this, "Finish Analysis", new Rule[]{new PruneSubqueryAliases(), CleanAliases.INSTANCE});
        return Arrays.asList(substitution, resolution, finish);
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        return this.analyze(plan, true);
    }

    public LogicalPlan analyze(LogicalPlan plan, boolean verify) {
        if (plan.analyzed()) {
            return plan;
        }
        return verify ? this.verify((LogicalPlan)this.execute((Node)plan)) : (LogicalPlan)this.execute((Node)plan);
    }

    public RuleExecutor.ExecutionInfo debugAnalyze(LogicalPlan plan) {
        return plan.analyzed() ? null : this.executeWithInfo((Node)plan);
    }

    public LogicalPlan verify(LogicalPlan plan) {
        Collection<Failure> failures = this.verifier.verify(plan);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    private static <E extends Expression> E resolveExpression(E expression, LogicalPlan plan) {
        return (E)((Expression)expression.transformUp(e -> {
            if (e instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)e;
                Attribute a = Analyzer.resolveAgainstList(ua, plan.output());
                return a != null ? a : e;
            }
            return e;
        }));
    }

    private static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList) {
        return Analyzer.resolveAgainstList(u, attrList, false);
    }

    private static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, boolean allowCompound) {
        ArrayList<Attribute> matches = new ArrayList<Attribute>();
        boolean qualified = u.qualifier() != null;
        for (Attribute attribute : attrList) {
            boolean match;
            if (attribute.synthetic() || !(match = qualified ? Objects.equals(u.qualifiedName(), attribute.qualifiedName()) : Objects.equals(u.name(), attribute.name()) || Objects.equals(u.name(), attribute.qualifiedName()))) continue;
            matches.add(attribute);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return Analyzer.handleSpecialFields(u, ((Attribute)matches.get(0)).withLocation(u.source()), allowCompound);
        }
        List refs = matches.stream().sorted((a, b) -> {
            int lineDiff = a.sourceLocation().getLineNumber() - b.sourceLocation().getLineNumber();
            int colDiff = a.sourceLocation().getColumnNumber() - b.sourceLocation().getColumnNumber();
            return lineDiff != 0 ? lineDiff : (colDiff != 0 ? colDiff : a.qualifiedName().compareTo(b.qualifiedName()));
        }).map(a -> "line " + a.sourceLocation().toString().substring(1) + " [" + (a.qualifier() != null ? "\"" + a.qualifier() + "\".\"" + a.name() + "\"" : a.name()) + "]").collect(Collectors.toList());
        return u.withUnresolvedMessage("Reference [" + u.qualifiedName() + "] is ambiguous (to disambiguate use quotes or qualifiers); matches any of " + refs);
    }

    private static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named, boolean allowCompound) {
        if (named instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)named;
            if (fa.field() instanceof InvalidMappedField) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] due to ambiguities being " + ((InvalidMappedField)fa.field()).errorMessage());
            } else if (DataTypes.isUnsupported((DataType)fa.dataType())) {
                UnsupportedEsField unsupportedField = (UnsupportedEsField)fa.field();
                named = unsupportedField.hasInherited() ? u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "] in hierarchy (field [" + unsupportedField.getInherited() + "])") : u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "]");
            } else if (!allowCompound && !DataTypes.isPrimitive((DataType)fa.dataType())) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + fa.dataType().typeName() + "] only its subfields");
            }
        }
        return named;
    }

    private static boolean hasStar(List<? extends Expression> exprs) {
        for (Expression expression : exprs) {
            if (!(expression instanceof UnresolvedStar)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAggregate(List<? extends Expression> list) {
        return Expressions.anyMatch(list, Functions::isAggregate);
    }

    private static boolean containsAggregate(Expression exp) {
        return Analyzer.containsAggregate(Collections.singletonList(exp));
    }

    private static class CTESubstitution
    extends AnalyzeRule<With> {
        private CTESubstitution() {
        }

        @Override
        protected LogicalPlan rule(With plan) {
            return this.substituteCTE(plan.child(), plan.subQueries());
        }

        private LogicalPlan substituteCTE(LogicalPlan p, Map<String, SubQueryAlias> subQueries) {
            if (p instanceof UnresolvedRelation) {
                UnresolvedRelation ur = (UnresolvedRelation)p;
                SubQueryAlias subQueryAlias = subQueries.get(ur.table().index());
                if (subQueryAlias != null) {
                    if (ur.alias() != null) {
                        return new SubQueryAlias(ur.source(), (LogicalPlan)subQueryAlias, ur.alias());
                    }
                    return subQueryAlias;
                }
                return ur;
            }
            if (p instanceof LocalRelation) {
                return p;
            }
            return (LogicalPlan)p.transformExpressionsDown(e -> {
                if (e instanceof SubQueryExpression) {
                    SubQueryExpression sq = (SubQueryExpression)((Object)e);
                    return sq.withQuery(this.substituteCTE(sq.query(), subQueries));
                }
                return e;
            });
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }

    private class ResolveTable
    extends AnalyzeRule<UnresolvedRelation> {
        private ResolveTable() {
        }

        @Override
        protected LogicalPlan rule(UnresolvedRelation plan) {
            TableIdentifier table = plan.table();
            if (!Analyzer.this.indexResolution.isValid()) {
                return plan.unresolvedMessage().equals(Analyzer.this.indexResolution.toString()) ? plan : new UnresolvedRelation(plan.source(), plan.table(), plan.alias(), plan.frozen(), Analyzer.this.indexResolution.toString());
            }
            assert (Analyzer.this.indexResolution.matches(table.index()));
            EsRelation logicalPlan = new EsRelation(plan.source(), Analyzer.this.indexResolution.get(), plan.frozen());
            SubQueryAlias sa = new SubQueryAlias(plan.source(), (LogicalPlan)logicalPlan, table.index());
            if (plan.alias() != null) {
                sa = new SubQueryAlias(plan.source(), (LogicalPlan)sa, plan.alias());
            }
            return sa;
        }
    }

    private static class ResolveRefs
    extends BaseAnalyzeRule {
        private ResolveRefs() {
        }

        @Override
        protected LogicalPlan doRule(LogicalPlan plan) {
            OrderBy o;
            if (plan instanceof Project) {
                Project p = (Project)plan;
                if (Analyzer.hasStar(p.projections())) {
                    return new Project(p.source(), p.child(), this.expandProjections(p.projections(), p.child()));
                }
            } else if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (Analyzer.hasStar(a.aggregates())) {
                    return new Aggregate(a.source(), a.child(), a.groupings(), this.expandProjections(a.aggregates(), a.child()));
                }
                if (!a.expressionsResolved() && Resolvables.resolved((Iterable)a.aggregates())) {
                    List groupings = a.groupings();
                    ArrayList<Expression> newGroupings = new ArrayList<Expression>();
                    List resolvedAliases = Expressions.aliases((List)a.aggregates());
                    boolean changed = false;
                    for (Object grouping : groupings) {
                        Attribute maybeResolved;
                        if (grouping instanceof UnresolvedAttribute && (maybeResolved = Analyzer.resolveAgainstList((UnresolvedAttribute)grouping, resolvedAliases.stream().map(Tuple::v1).collect(Collectors.toList()))) != null) {
                            changed = true;
                            grouping = maybeResolved.resolved() ? resolvedAliases.stream().filter(t -> ((Attribute)t.v1()).equals((Object)maybeResolved)).map(Tuple::v2).findAny().get() : maybeResolved;
                        }
                        newGroupings.add((Expression)grouping);
                    }
                    return changed ? new Aggregate(a.source(), a.child(), newGroupings, a.aggregates()) : a;
                }
            } else if (plan instanceof Join) {
                Join j = (Join)plan;
                if (!j.duplicatesResolved()) {
                    LogicalPlan deduped = this.dedupRight(j.left(), j.right());
                    return new Join(j.source(), j.left(), deduped, j.type(), j.condition());
                }
            } else if (plan instanceof OrderBy && !(o = (OrderBy)plan).resolved()) {
                ArrayList<Order> resolvedOrder = new ArrayList<Order>(o.order().size());
                for (Order order : o.order()) {
                    resolvedOrder.add((Order)Analyzer.resolveExpression((Expression)order, o.child()));
                }
                return new OrderBy(o.source(), o.child(), resolvedOrder);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attempting to resolve {}", (Object)plan.nodeString());
            }
            return (LogicalPlan)plan.transformExpressionsUp(e -> {
                if (e instanceof UnresolvedAttribute) {
                    UnresolvedAttribute u = (UnresolvedAttribute)e;
                    ArrayList childrenOutput = new ArrayList();
                    for (LogicalPlan child : plan.children()) {
                        childrenOutput.addAll(child.output());
                    }
                    Attribute named = Analyzer.resolveAgainstList(u, childrenOutput);
                    if (named != null) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Resolved {} to {}", (Object)u, (Object)named);
                        }
                        return named;
                    }
                }
                return e;
            });
        }

        private List<NamedExpression> expandProjections(List<? extends NamedExpression> projections, LogicalPlan child) {
            ArrayList<NamedExpression> result = new ArrayList<NamedExpression>();
            List output = child.output();
            for (NamedExpression namedExpression : projections) {
                if (namedExpression instanceof UnresolvedStar) {
                    List<NamedExpression> expanded = ResolveRefs.expandStar((UnresolvedStar)namedExpression, output);
                    if (expanded.isEmpty()) {
                        result.add(namedExpression);
                        continue;
                    }
                    result.addAll(expanded);
                    continue;
                }
                if (namedExpression instanceof UnresolvedAlias) {
                    UnresolvedAlias ua = (UnresolvedAlias)namedExpression;
                    if (!(ua.child() instanceof UnresolvedStar)) continue;
                    result.addAll(ResolveRefs.expandStar((UnresolvedStar)ua.child(), output));
                    continue;
                }
                result.add(namedExpression);
            }
            return result;
        }

        static List<NamedExpression> expandStar(UnresolvedStar us, List<Attribute> output) {
            ArrayList<NamedExpression> expanded = new ArrayList<NamedExpression>();
            if (us.qualifier() != null) {
                Attribute q = Analyzer.resolveAgainstList(us.qualifier(), output, true);
                if (q == null) {
                    return Collections.singletonList(us.qualifier());
                }
                if (!q.resolved()) {
                    return Collections.singletonList(q);
                }
                for (Attribute attr : output) {
                    FieldAttribute fa;
                    if (!(attr instanceof FieldAttribute) || DataTypes.isUnsupported((DataType)(fa = (FieldAttribute)attr).dataType())) continue;
                    if (q.qualifier() != null) {
                        if (!Objects.equals(q.qualifiedName(), fa.qualifiedPath())) continue;
                        expanded.add((NamedExpression)fa.withLocation(attr.source()));
                        continue;
                    }
                    if (!Objects.equals(q.name(), fa.path())) continue;
                    expanded.add((NamedExpression)fa.withLocation(attr.source()));
                }
            } else {
                expanded.addAll(Expressions.onlyPrimitiveFieldAttributes(output));
            }
            return expanded;
        }

        private LogicalPlan dedupRight(LogicalPlan left, LogicalPlan right) {
            AttributeSet conflicting = left.outputSet().intersect(right.outputSet());
            if (this.log.isTraceEnabled()) {
                this.log.trace("Trying to resolve conflicts " + conflicting + " between left " + left.nodeString() + " and right " + right.nodeString());
            }
            throw new UnsupportedOperationException("don't know how to resolve conficting IDs yet");
        }
    }

    private static class ResolveOrdinalInOrderByAndGroupBy
    extends BaseAnalyzeRule {
        private ResolveOrdinalInOrderByAndGroupBy() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan doRule(LogicalPlan plan) {
            if (plan instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)plan;
                boolean changed = false;
                ArrayList<Order> newOrder = new ArrayList<Order>(orderBy.order().size());
                List ordinalReference = orderBy.child().output();
                int max = ordinalReference.size();
                for (Order order : orderBy.order()) {
                    Expression child = order.child();
                    Integer ordinal = this.findOrdinal(order.child());
                    if (ordinal != null) {
                        changed = true;
                        if (ordinal > 0 && ordinal <= max) {
                            newOrder.add(new Order(order.source(), (Expression)orderBy.child().output().get(ordinal - 1), order.direction(), order.nullsPosition()));
                            continue;
                        }
                        String message = LoggerMessageFormat.format((String)"Invalid ordinal [{}] specified in [{}] (valid range is [1, {}])", (Object[])new Object[]{ordinal, orderBy.sourceText(), max});
                        UnresolvedAttribute ua = new UnresolvedAttribute(child.source(), orderBy.sourceText(), null, message);
                        newOrder.add(new Order(order.source(), (Expression)ua, order.direction(), order.nullsPosition()));
                        continue;
                    }
                    newOrder.add(order);
                }
                return changed ? new OrderBy(orderBy.source(), orderBy.child(), newOrder) : orderBy;
            }
            if (plan instanceof Aggregate) {
                Aggregate agg = (Aggregate)plan;
                if (!Resolvables.resolved((Iterable)agg.aggregates())) {
                    return agg;
                }
                boolean changed = false;
                ArrayList<Object> newGroupings = new ArrayList<Object>(agg.groupings().size());
                List aggregates = agg.aggregates();
                int max = aggregates.size();
                for (Expression exp : agg.groupings()) {
                    Integer ordinal = this.findOrdinal(exp);
                    if (ordinal != null) {
                        changed = true;
                        String errorMessage = null;
                        if (ordinal > 0 && ordinal <= max) {
                            NamedExpression reference = (NamedExpression)aggregates.get(ordinal - 1);
                            if (Analyzer.containsAggregate((Expression)reference)) {
                                errorMessage = LoggerMessageFormat.format((String)"Ordinal [{}] in [{}] refers to an invalid argument, aggregate function [{}]", (Object[])new Object[]{ordinal, agg.sourceText(), reference.sourceText()});
                            } else {
                                newGroupings.add(reference);
                            }
                        } else {
                            errorMessage = LoggerMessageFormat.format((String)"Invalid ordinal [{}] specified in [{}] (valid range is [1, {}])", (Object[])new Object[]{ordinal, agg.sourceText(), max});
                        }
                        if (errorMessage == null) continue;
                        newGroupings.add(new UnresolvedAttribute(exp.source(), agg.sourceText(), null, errorMessage));
                        continue;
                    }
                    newGroupings.add(exp);
                }
                return changed ? new Aggregate(agg.source(), agg.child(), newGroupings, aggregates) : agg;
            }
            return plan;
        }

        private Integer findOrdinal(Expression expression) {
            Object v;
            if (expression.foldable() && expression.dataType().isInteger() && (v = Foldables.valueOf((Expression)expression)) instanceof Number) {
                return ((Number)v).intValue();
            }
            return null;
        }
    }

    private static class ResolveMissingRefs
    extends BaseAnalyzeRule {
        private ResolveMissingRefs() {
        }

        @Override
        protected LogicalPlan doRule(LogicalPlan plan) {
            LogicalPlan child;
            if (plan instanceof OrderBy) {
                AttributeSet resolvedRefs;
                AttributeSet missing;
                OrderBy o = (OrderBy)plan;
                child = o.child();
                ArrayList<Order> maybeResolved = new ArrayList<Order>();
                for (Order or : o.order()) {
                    maybeResolved.add(or.resolved() ? or : ResolveMissingRefs.tryResolveExpression(or, child));
                }
                Stream<Order> referencesStream = maybeResolved.stream().filter(Expression::resolved);
                if (Expressions.hasReferenceAttribute((Collection)child.outputSet())) {
                    LinkedHashMap collectRefs = new LinkedHashMap();
                    child.forEachUp(p -> p.forEachExpressionsUp(e -> {
                        if (e instanceof Alias) {
                            Alias a = (Alias)e;
                            collectRefs.put(a.toAttribute(), a.child());
                        }
                    }));
                    referencesStream = referencesStream.filter(r -> {
                        for (Attribute attr : child.outputSet()) {
                            Expression source;
                            if (!(attr instanceof ReferenceAttribute) || !(source = (Expression)collectRefs.getOrDefault(attr, attr)).equals((Object)r.child())) continue;
                            return false;
                        }
                        return true;
                    });
                }
                if (!(missing = (resolvedRefs = Expressions.references(referencesStream.collect(Collectors.toList()))).subtract(child.outputSet())).isEmpty()) {
                    ArrayList<Attribute> failedAttrs = new ArrayList<Attribute>();
                    LogicalPlan newChild = ResolveMissingRefs.propagateMissing(o.child(), missing, failedAttrs);
                    if (!failedAttrs.isEmpty()) {
                        ArrayList<Order> newOrders = new ArrayList<Order>();
                        for (Order order : o.order()) {
                            Order transformed;
                            newOrders.add(order.equals((Object)(transformed = (Order)order.transformUp(ua -> ResolveMissingRefs.resolveMetadataToMessage(ua, failedAttrs, "order"), UnresolvedAttribute.class))) ? order : transformed);
                        }
                        return o.order().equals(newOrders) ? o : new OrderBy(o.source(), o.child(), newOrders);
                    }
                    return new Project(o.source(), (LogicalPlan)new OrderBy(o.source(), newChild, maybeResolved), o.child().output());
                }
                if (!maybeResolved.equals(o.order())) {
                    return new OrderBy(o.source(), o.child(), maybeResolved);
                }
            }
            if (plan instanceof Filter) {
                Filter f = (Filter)plan;
                Expression maybeResolved = ResolveMissingRefs.tryResolveExpression(f.condition(), f.child());
                AttributeSet resolvedRefs = new AttributeSet((Collection)maybeResolved.references().stream().filter(Expression::resolved).collect(Collectors.toList()));
                AttributeSet missing = resolvedRefs.subtract(f.child().outputSet());
                if (!missing.isEmpty()) {
                    ArrayList<Attribute> failedAttrs = new ArrayList<Attribute>();
                    LogicalPlan newChild = ResolveMissingRefs.propagateMissing(f.child(), missing, failedAttrs);
                    if (!failedAttrs.isEmpty()) {
                        Expression transformed = (Expression)f.condition().transformUp(ua -> ResolveMissingRefs.resolveMetadataToMessage(ua, failedAttrs, "filter"), UnresolvedAttribute.class);
                        return f.condition().equals((Object)transformed) ? f : new Filter(f.source(), f.child(), transformed);
                    }
                    return new Project(f.source(), (LogicalPlan)new Filter(f.source(), newChild, maybeResolved), f.child().output());
                }
                if (!maybeResolved.equals((Object)f.condition())) {
                    return new Filter(f.source(), f.child(), maybeResolved);
                }
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                child = a.child();
                ArrayList newGroupings = new ArrayList(a.groupings().size());
                a.groupings().forEach(e -> newGroupings.add(ResolveMissingRefs.tryResolveExpression(e, child)));
                ArrayList newAggregates = new ArrayList(a.aggregates().size());
                a.aggregates().forEach(e -> newAggregates.add(ResolveMissingRefs.tryResolveExpression(e, child)));
                if (!newAggregates.equals(a.aggregates()) || !newGroupings.equals(a.groupings())) {
                    return new Aggregate(a.source(), child, newGroupings, newAggregates);
                }
            }
            return plan;
        }

        static <E extends Expression> E tryResolveExpression(E exp, LogicalPlan plan) {
            Expression resolved = Analyzer.resolveExpression(exp, plan);
            if (!resolved.resolved() && plan.children().size() == 1 && !(plan instanceof SubQueryAlias)) {
                return (E)ResolveMissingRefs.tryResolveExpression(resolved, (LogicalPlan)plan.children().get(0));
            }
            return (E)resolved;
        }

        private static LogicalPlan propagateMissing(LogicalPlan plan, AttributeSet missing, List<Attribute> failed) {
            if (missing.isEmpty()) {
                return plan;
            }
            if (plan instanceof Project) {
                Project p = (Project)plan;
                AttributeSet diff = missing.subtract(p.child().outputSet());
                return new Project(p.source(), ResolveMissingRefs.propagateMissing(p.child(), diff, failed), CollectionUtils.combine((Collection[])new Collection[]{p.projections(), missing}));
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                for (Attribute m : missing) {
                    if (Expressions.match((List)a.groupings(), arg_0 -> ((Attribute)m).semanticEquals(arg_0))) continue;
                    if (m instanceof Attribute) {
                        m = new UnresolvedAttribute(m.source(), m.name(), m.qualifier(), null, null, (Object)new AggGroupingFailure(Expressions.names((Collection)a.groupings())));
                    }
                    failed.add(m);
                }
                if (!failed.isEmpty()) {
                    return plan;
                }
                return new Aggregate(a.source(), a.child(), a.groupings(), CollectionUtils.combine((Collection[])new Collection[]{a.aggregates(), missing}));
            }
            if (plan instanceof UnaryPlan) {
                return (LogicalPlan)plan.replaceChildren(Collections.singletonList(ResolveMissingRefs.propagateMissing(((UnaryPlan)plan).child(), missing, failed)));
            }
            failed.addAll((Collection<Attribute>)missing);
            return plan;
        }

        private static UnresolvedAttribute resolveMetadataToMessage(UnresolvedAttribute ua, List<Attribute> attrs, String actionName) {
            for (Attribute attr : attrs) {
                UnresolvedAttribute fua;
                Object metadata;
                if (ua.resolutionMetadata() != null || !attr.name().equals(ua.name()) || !(attr instanceof UnresolvedAttribute) || !((metadata = (fua = (UnresolvedAttribute)attr).resolutionMetadata()) instanceof AggGroupingFailure)) continue;
                List<String> names = ((AggGroupingFailure)metadata).expectedGrouping;
                return ua.withUnresolvedMessage("Cannot " + actionName + " by non-grouped column [" + ua.qualifiedName() + "], expected " + names);
            }
            return ua;
        }

        private static class AggGroupingFailure {
            final List<String> expectedGrouping;

            private AggGroupingFailure(List<String> expectedGrouping) {
                this.expectedGrouping = expectedGrouping;
            }
        }
    }

    private class ResolveFilterRefs
    extends AnalyzeRule<LogicalPlan> {
        private ResolveFilterRefs() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            Aggregate a;
            Expression newCondition;
            Filter f;
            Expression condition;
            Project p;
            if (plan instanceof Project && (p = (Project)plan).child() instanceof Filter && !(condition = (f = (Filter)p.child()).condition()).resolved() && f.childrenResolved() && (newCondition = this.replaceAliases(condition, p.projections())) != condition) {
                return new Project(p.source(), (LogicalPlan)new Filter(f.source(), f.child(), newCondition), p.projections());
            }
            if (plan instanceof Aggregate && (a = (Aggregate)plan).child() instanceof Filter && !(condition = (f = (Filter)a.child()).condition()).resolved() && f.childrenResolved() && (newCondition = this.replaceAliases(condition, a.aggregates())) != condition) {
                return new Aggregate(a.source(), (LogicalPlan)new Filter(f.source(), f.child(), newCondition), a.groupings(), a.aggregates());
            }
            return plan;
        }

        private Expression replaceAliases(Expression condition, List<? extends NamedExpression> named) {
            ArrayList aliases = new ArrayList();
            named.forEach(n -> {
                if (n instanceof Alias) {
                    aliases.add((Alias)n);
                }
            });
            return (Expression)condition.transformDown(u -> {
                boolean qualified = u.qualifier() != null;
                for (Alias alias : aliases) {
                    if (alias.anyMatch(e -> e == u) || !(qualified ? Objects.equals(alias.qualifiedName(), u.qualifiedName()) : Objects.equals(alias.name(), u.name()))) continue;
                    return alias;
                }
                return u;
            }, UnresolvedAttribute.class);
        }
    }

    private class ResolveFunctions
    extends AnalyzeRule<LogicalPlan> {
        private ResolveFunctions() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            return (LogicalPlan)plan.transformExpressionsUp(e -> {
                if (e instanceof UnresolvedFunction) {
                    UnresolvedFunction uf = (UnresolvedFunction)e;
                    if (uf.analyzed()) {
                        return uf;
                    }
                    String name = uf.name();
                    if (Analyzer.hasStar(uf.arguments()) && (uf = uf.preprocessStar()).analyzed()) {
                        return uf;
                    }
                    if (!uf.childrenResolved()) {
                        return uf;
                    }
                    String functionName = Analyzer.this.functionRegistry.resolveAlias(name);
                    if (!Analyzer.this.functionRegistry.functionExists(functionName)) {
                        return uf.missing(functionName, (Iterable)Analyzer.this.functionRegistry.listFunctions());
                    }
                    FunctionDefinition def = Analyzer.this.functionRegistry.resolveFunction(functionName);
                    Function f = uf.buildResolved(Analyzer.this.configuration, def);
                    return f;
                }
                return e;
            });
        }
    }

    private static class ResolveAliases
    extends BaseAnalyzeRule {
        private ResolveAliases() {
        }

        @Override
        protected LogicalPlan doRule(LogicalPlan plan) {
            if (plan instanceof Project) {
                Project p = (Project)plan;
                if (this.hasUnresolvedAliases(p.projections())) {
                    return new Project(p.source(), p.child(), this.assignAliases(p.projections()));
                }
                return p;
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (this.hasUnresolvedAliases(a.aggregates())) {
                    return new Aggregate(a.source(), a.child(), a.groupings(), this.assignAliases(a.aggregates()));
                }
                return a;
            }
            if (plan instanceof Pivot) {
                Pivot p = (Pivot)plan;
                if (this.hasUnresolvedAliases(p.values())) {
                    p = new Pivot(p.source(), p.child(), p.column(), this.assignAliases(p.values()), p.aggregates());
                }
                if (this.hasUnresolvedAliases(p.aggregates())) {
                    p = new Pivot(p.source(), p.child(), p.column(), p.values(), this.assignAliases(p.aggregates()));
                }
                return p;
            }
            return plan;
        }

        private boolean hasUnresolvedAliases(List<? extends NamedExpression> expressions) {
            return expressions != null && Expressions.anyMatch(expressions, e -> e instanceof UnresolvedAlias);
        }

        private List<NamedExpression> assignAliases(List<? extends NamedExpression> exprs) {
            ArrayList<NamedExpression> newExpr = new ArrayList<NamedExpression>(exprs.size());
            for (int i = 0; i < exprs.size(); ++i) {
                NamedExpression transformed;
                NamedExpression expr = exprs.get(i);
                newExpr.add(expr.equals((Object)(transformed = (NamedExpression)expr.transformUp(ua -> {
                    Cast c;
                    Expression child = ua.child();
                    if (child instanceof NamedExpression) {
                        return child;
                    }
                    if (!child.resolved()) {
                        return ua;
                    }
                    if (child instanceof Cast && (c = (Cast)child).field() instanceof NamedExpression) {
                        return new Alias(c.source(), ((NamedExpression)c.field()).name(), (Expression)c);
                    }
                    return new Alias(child.source(), child.sourceText(), child);
                }, UnresolvedAlias.class))) ? expr : transformed);
            }
            return newExpr;
        }
    }

    private static class ProjectedAggregations
    extends AnalyzeRule<Project> {
        private ProjectedAggregations() {
        }

        @Override
        protected LogicalPlan rule(Project p) {
            if (Analyzer.containsAggregate(p.projections())) {
                return new Aggregate(p.source(), p.child(), Collections.emptyList(), p.projections());
            }
            return p;
        }
    }

    private static class HavingOverProject
    extends AnalyzeRule<Filter> {
        private HavingOverProject() {
        }

        @Override
        protected LogicalPlan rule(Filter f) {
            if (f.child() instanceof Project) {
                Project p = (Project)f.child();
                for (Expression n : p.projections()) {
                    if (n instanceof Alias) {
                        n = ((Alias)n).child();
                    }
                    if (n.foldable() || Functions.isAggregate((Expression)n) || !n.anyMatch(e -> e instanceof FieldAttribute)) continue;
                    return f;
                }
                if (Analyzer.containsAggregate(f.condition())) {
                    return new Filter(f.source(), (LogicalPlan)new Aggregate(p.source(), p.child(), Collections.emptyList(), p.projections()), f.condition());
                }
            }
            return f;
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }

    private class ResolveAggsInHaving
    extends AnalyzeRule<Filter> {
        private ResolveAggsInHaving() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan rule(Filter f) {
            if (f.child() instanceof Aggregate && f.child().resolved()) {
                Aggregate agg = (Aggregate)f.child();
                Set<NamedExpression> missing = null;
                Expression condition = f.condition();
                if (!condition.resolved()) {
                    Aggregate tryResolvingCondition = new Aggregate(agg.source(), agg.child(), agg.groupings(), CollectionUtils.combine((Collection)agg.aggregates(), (Object[])new NamedExpression[]{new Alias(f.source(), ".having", condition)}));
                    if ((tryResolvingCondition = (Aggregate)Analyzer.this.analyze((LogicalPlan)tryResolvingCondition, false)).resolved()) {
                        condition = ((Alias)tryResolvingCondition.aggregates().get(tryResolvingCondition.aggregates().size() - 1)).child();
                    } else {
                        return f;
                    }
                }
                if (!(missing = this.findMissingAggregate(agg, condition)).isEmpty()) {
                    Aggregate newAgg = new Aggregate(agg.source(), agg.child(), agg.groupings(), CollectionUtils.combine((Collection[])new Collection[]{agg.aggregates(), missing}));
                    Filter newFilter = new Filter(f.source(), (LogicalPlan)newAgg, condition);
                    return new Project(f.source(), (LogicalPlan)newFilter, f.output());
                }
                return new Filter(f.source(), f.child(), condition);
            }
            return f;
        }

        private Set<NamedExpression> findMissingAggregate(Aggregate target, Expression from) {
            LinkedHashSet<NamedExpression> missing = new LinkedHashSet<NamedExpression>();
            for (Expression filterAgg : from.collect(Functions::isAggregate)) {
                if (Expressions.anyMatch((List)target.aggregates(), a -> {
                    if (a instanceof Alias) {
                        a = ((Alias)a).child();
                    }
                    return a.equals((Object)filterAgg);
                })) continue;
                missing.add(Expressions.wrapAsNamed((Expression)filterAgg));
            }
            return missing;
        }
    }

    private static class ResolveAggsInOrderBy
    extends AnalyzeRule<OrderBy> {
        private ResolveAggsInOrderBy() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan rule(OrderBy ob) {
            List orders = ob.order();
            ArrayList<Expression> aggs = new ArrayList<Expression>();
            for (Order order : orders) {
                if (!Functions.isAggregate((Expression)order.child())) continue;
                aggs.add(order.child());
            }
            if (aggs.isEmpty()) {
                return ob;
            }
            Holder found = new Holder((Object)Boolean.FALSE);
            LogicalPlan plan = (LogicalPlan)ob.transformDown(a -> {
                if (found.get() == Boolean.FALSE) {
                    found.set((Object)Boolean.TRUE);
                    ArrayList<NamedExpression> missing = new ArrayList<NamedExpression>();
                    for (Expression orderedAgg : aggs) {
                        if (Expressions.anyMatch((List)a.aggregates(), e -> {
                            if (e instanceof Alias) {
                                e = ((Alias)e).child();
                            }
                            return e.equals((Object)orderedAgg);
                        })) continue;
                        missing.add(Expressions.wrapAsNamed((Expression)orderedAgg));
                    }
                    if (!missing.isEmpty()) {
                        return new Aggregate(a.source(), a.child(), a.groupings(), CollectionUtils.combine((List)a.aggregates(), missing));
                    }
                }
                return a;
            }, Aggregate.class);
            if (plan != ob) {
                return new Project(ob.source(), plan, ob.output());
            }
            return ob;
        }
    }

    public static class PruneSubqueryAliases
    extends AnalyzeRule<SubQueryAlias> {
        @Override
        protected LogicalPlan rule(SubQueryAlias alias) {
            return alias.child();
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }

    public static class CleanAliases
    extends AnalyzeRule<LogicalPlan> {
        public static final CleanAliases INSTANCE = new CleanAliases();

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (plan instanceof Project) {
                Project p = (Project)plan;
                return new Project(p.source(), p.child(), this.cleanChildrenAliases(p.projections()));
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                return new Aggregate(a.source(), a.child(), this.cleanAllAliases(a.groupings()), this.cleanChildrenAliases(a.aggregates()));
            }
            if (plan instanceof Pivot) {
                Pivot p = (Pivot)plan;
                return new Pivot(p.source(), p.child(), CleanAliases.trimAliases(p.column()), this.cleanChildrenAliases(p.values()), this.cleanChildrenAliases(p.aggregates()));
            }
            return (LogicalPlan)plan.transformExpressionsOnly(e -> {
                if (e instanceof Alias) {
                    return ((Alias)e).child();
                }
                return e;
            });
        }

        private List<NamedExpression> cleanChildrenAliases(List<? extends NamedExpression> args) {
            ArrayList<NamedExpression> cleaned = new ArrayList<NamedExpression>(args.size());
            for (NamedExpression namedExpression : args) {
                cleaned.add((NamedExpression)CleanAliases.trimNonTopLevelAliases((Expression)namedExpression));
            }
            return cleaned;
        }

        private List<Expression> cleanAllAliases(List<Expression> args) {
            ArrayList<Expression> cleaned = new ArrayList<Expression>(args.size());
            for (Expression e : args) {
                cleaned.add(CleanAliases.trimAliases(e));
            }
            return cleaned;
        }

        public static Expression trimNonTopLevelAliases(Expression e) {
            if (e instanceof Alias) {
                Alias a = (Alias)e;
                return new Alias(a.source(), a.name(), a.qualifier(), CleanAliases.trimAliases(a.child()), a.id());
            }
            return CleanAliases.trimAliases(e);
        }

        private static Expression trimAliases(Expression e) {
            return (Expression)e.transformDown(Alias::child, Alias.class);
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }

    static abstract class BaseAnalyzeRule
    extends AnalyzeRule<LogicalPlan> {
        BaseAnalyzeRule() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            return this.doRule(plan);
        }

        protected abstract LogicalPlan doRule(LogicalPlan var1);
    }

    static abstract class AnalyzeRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        AnalyzeRule() {
        }

        public final LogicalPlan apply(LogicalPlan plan) {
            return (LogicalPlan)plan.transformUp(t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t), this.typeToken());
        }

        protected abstract LogicalPlan rule(SubPlan var1);

        protected boolean skipResolved() {
            return true;
        }
    }

    private class ImplicitCasting
    extends AnalyzeRule<LogicalPlan> {
        private ImplicitCasting() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            return (LogicalPlan)plan.transformExpressionsDown(this::implicitCast);
        }

        private Expression implicitCast(Expression e) {
            DataType r;
            DataType l;
            if (!e.childrenResolved()) {
                return e;
            }
            Expression left = null;
            Expression right = null;
            if (e instanceof ArithmeticOperation) {
                ArithmeticOperation f = (ArithmeticOperation)e;
                left = f.left();
                right = f.right();
            }
            if (left != null && (l = left.dataType()) != (r = right.dataType())) {
                DataType common = SqlDataTypeConverter.commonType(l, r);
                if (common == null) {
                    return e;
                }
                left = l == common ? left : new Cast(left.source(), left, common);
                right = r == common ? right : new Cast(right.source(), right, common);
                return (Expression)e.replaceChildren(Arrays.asList(left, right));
            }
            return e;
        }
    }
}

