/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;
import org.elasticsearch.xpack.enrich.EnrichPlugin;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;
import org.elasticsearch.xpack.enrich.EnrichPolicyRunner;
import org.elasticsearch.xpack.enrich.EnrichStore;
import org.elasticsearch.xpack.enrich.ExecuteEnrichPolicyTask;

public class EnrichPolicyExecutor {
    public static final String TASK_ACTION = "policy_execution";
    private final ClusterService clusterService;
    private final Client client;
    private final TaskManager taskManager;
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final LongSupplier nowSupplier;
    private final int fetchSize;
    private final EnrichPolicyLocks policyLocks;
    private final int maximumConcurrentPolicyExecutions;
    private final int maxForceMergeAttempts;
    private final Semaphore policyExecutionPermits;

    public EnrichPolicyExecutor(Settings settings, ClusterService clusterService, Client client, TaskManager taskManager, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, EnrichPolicyLocks policyLocks, LongSupplier nowSupplier) {
        this.clusterService = clusterService;
        this.client = client;
        this.taskManager = taskManager;
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.nowSupplier = nowSupplier;
        this.policyLocks = policyLocks;
        this.fetchSize = (Integer)EnrichPlugin.ENRICH_FETCH_SIZE_SETTING.get(settings);
        this.maximumConcurrentPolicyExecutions = (Integer)EnrichPlugin.ENRICH_MAX_CONCURRENT_POLICY_EXECUTIONS.get(settings);
        this.maxForceMergeAttempts = (Integer)EnrichPlugin.ENRICH_MAX_FORCE_MERGE_ATTEMPTS.get(settings);
        this.policyExecutionPermits = new Semaphore(this.maximumConcurrentPolicyExecutions);
    }

    private void tryLockingPolicy(String policyName) {
        this.policyLocks.lockPolicy(policyName);
        if (!this.policyExecutionPermits.tryAcquire()) {
            this.policyLocks.releasePolicy(policyName);
            throw new EsRejectedExecutionException("Policy execution failed. Policy execution for [" + policyName + "] would exceed maximum concurrent policy executions [" + this.maximumConcurrentPolicyExecutions + "]");
        }
    }

    private void releasePolicy(String policyName) {
        try {
            this.policyExecutionPermits.release();
        }
        finally {
            this.policyLocks.releasePolicy(policyName);
        }
    }

    protected Runnable createPolicyRunner(String policyName, EnrichPolicy policy, ExecuteEnrichPolicyTask task, ActionListener<ExecuteEnrichPolicyStatus> listener) {
        return new EnrichPolicyRunner(policyName, policy, task, listener, this.clusterService, this.client, this.indexNameExpressionResolver, this.nowSupplier, this.fetchSize, this.maxForceMergeAttempts);
    }

    private EnrichPolicy getPolicy(ExecuteEnrichPolicyAction.Request request) {
        EnrichPolicy policy = EnrichStore.getPolicy(request.getName(), this.clusterService.state());
        if (policy == null) {
            throw new IllegalArgumentException("Policy execution failed. Could not locate policy with id [" + request.getName() + "]");
        }
        return policy;
    }

    public Task runPolicy(ExecuteEnrichPolicyAction.Request request, ActionListener<ExecuteEnrichPolicyStatus> listener) {
        return this.runPolicy(request, this.getPolicy(request), listener);
    }

    public Task runPolicy(ExecuteEnrichPolicyAction.Request request, TaskListener<ExecuteEnrichPolicyStatus> listener) {
        return this.runPolicy(request, this.getPolicy(request), listener);
    }

    public Task runPolicy(ExecuteEnrichPolicyAction.Request request, EnrichPolicy policy, ActionListener<ExecuteEnrichPolicyStatus> listener) {
        return this.runPolicy(request, policy, (t, r) -> listener.onResponse(r), (t, e) -> listener.onFailure(e));
    }

    public Task runPolicy(ExecuteEnrichPolicyAction.Request request, EnrichPolicy policy, TaskListener<ExecuteEnrichPolicyStatus> listener) {
        return this.runPolicy(request, policy, (arg_0, arg_1) -> listener.onResponse(arg_0, arg_1), (arg_0, arg_1) -> listener.onFailure(arg_0, arg_1));
    }

    private Task runPolicy(ExecuteEnrichPolicyAction.Request request, EnrichPolicy policy, BiConsumer<Task, ExecuteEnrichPolicyStatus> onResponse, BiConsumer<Task, Exception> onFailure) {
        this.tryLockingPolicy(request.getName());
        try {
            return this.runPolicyTask(request, policy, onResponse, onFailure);
        }
        catch (Exception e) {
            this.releasePolicy(request.getName());
            throw e;
        }
    }

    private Task runPolicyTask(final ExecuteEnrichPolicyAction.Request request, EnrichPolicy policy, BiConsumer<Task, ExecuteEnrichPolicyStatus> onResponse, BiConsumer<Task, Exception> onFailure) {
        Task asyncTask = this.taskManager.register("enrich", TASK_ACTION, new TaskAwareRequest(){

            public void setParentTask(TaskId taskId) {
                request.setParentTask(taskId);
            }

            public TaskId getParentTask() {
                return request.getParentTask();
            }

            public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
                return new ExecuteEnrichPolicyTask(id, type, action, this.getDescription(), parentTaskId, headers);
            }

            public String getDescription() {
                return request.getName();
            }
        });
        ExecuteEnrichPolicyTask task = (ExecuteEnrichPolicyTask)asyncTask;
        try {
            task.setStatus(new ExecuteEnrichPolicyStatus("SCHEDULED"));
            PolicyCompletionListener completionListener = new PolicyCompletionListener(request.getName(), task, onResponse, onFailure);
            Runnable runnable = this.createPolicyRunner(request.getName(), policy, task, completionListener);
            this.threadPool.executor("generic").execute(runnable);
            return asyncTask;
        }
        catch (Exception e) {
            task.setStatus(new ExecuteEnrichPolicyStatus("FAILED"));
            this.taskManager.unregister(asyncTask);
            throw e;
        }
    }

    private class PolicyCompletionListener
    implements ActionListener<ExecuteEnrichPolicyStatus> {
        private final String policyName;
        private final ExecuteEnrichPolicyTask task;
        private final BiConsumer<Task, ExecuteEnrichPolicyStatus> onResponse;
        private final BiConsumer<Task, Exception> onFailure;

        PolicyCompletionListener(String policyName, ExecuteEnrichPolicyTask task, BiConsumer<Task, ExecuteEnrichPolicyStatus> onResponse, BiConsumer<Task, Exception> onFailure) {
            this.policyName = policyName;
            this.task = task;
            this.onResponse = onResponse;
            this.onFailure = onFailure;
        }

        public void onResponse(ExecuteEnrichPolicyStatus status) {
            assert ("COMPLETE".equals(status.getPhase())) : "incomplete task returned";
            EnrichPolicyExecutor.this.releasePolicy(this.policyName);
            try {
                EnrichPolicyExecutor.this.taskManager.unregister((Task)this.task);
            }
            finally {
                this.onResponse.accept(this.task, status);
            }
        }

        public void onFailure(Exception e) {
            this.task.setStatus(new ExecuteEnrichPolicyStatus("FAILED"));
            EnrichPolicyExecutor.this.releasePolicy(this.policyName);
            try {
                EnrichPolicyExecutor.this.taskManager.unregister((Task)this.task);
            }
            finally {
                this.onFailure.accept(this.task, e);
            }
        }
    }
}

