/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;

public final class EnrichMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements XPackPlugin.XPackMetadataCustom {
    static final String TYPE = "enrich";
    static final ParseField POLICIES = new ParseField("policies", new String[0]);
    private static final ConstructingObjectParser<EnrichMetadata, Void> PARSER = new ConstructingObjectParser("enrich_metadata", args -> new EnrichMetadata((Map)args[0]));
    private final Map<String, EnrichPolicy> policies;

    public static EnrichMetadata fromXContent(XContentParser parser) throws IOException {
        return (EnrichMetadata)((Object)PARSER.parse(parser, null));
    }

    public EnrichMetadata(StreamInput in) throws IOException {
        this(in.readMap(StreamInput::readString, EnrichPolicy::new));
    }

    public EnrichMetadata(Map<String, EnrichPolicy> policies) {
        this.policies = Collections.unmodifiableMap(policies);
    }

    public Map<String, EnrichPolicy> getPolicies() {
        return this.policies;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_5_0;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.policies, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(POLICIES.getPreferredName());
        for (Map.Entry<String, EnrichPolicy> entry : this.policies.entrySet()) {
            builder.startObject(entry.getKey());
            builder.value((Object)entry.getValue());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EnrichMetadata that = (EnrichMetadata)((Object)o);
        return this.policies.equals(that.policies);
    }

    public int hashCode() {
        return Objects.hash(this.policies);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, EnrichPolicy> patterns = new HashMap<String, EnrichPolicy>();
            String fieldName = null;
            XContentParser.Token token = p.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = p.currentName();
                } else if (token == XContentParser.Token.START_OBJECT) {
                    patterns.put(fieldName, EnrichPolicy.fromXContent((XContentParser)p));
                } else {
                    throw new ElasticsearchParseException("unexpected token [" + token + "]", new Object[0]);
                }
                token = p.nextToken();
            }
            return patterns;
        }, POLICIES);
    }
}

