/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import java.util.Collection;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.saml.IdpConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SamlObjectHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusDetail;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class SamlResponseHandler
extends SamlObjectHandler {
    public SamlResponseHandler(Clock clock, IdpConfiguration idp, SpConfiguration sp, TimeValue maxSkew) {
        super(clock, idp, sp, maxSkew);
    }

    protected void checkInResponseTo(StatusResponseType response, Collection<String> allowedSamlRequestIds) {
        if (Strings.hasText((String)response.getInResponseTo()) && !allowedSamlRequestIds.contains(response.getInResponseTo())) {
            this.logger.debug("The SAML Response with ID [{}] is unsolicited. A user might have used a stale URL or the Identity Provider incorrectly populates the InResponseTo attribute", (Object)response.getID());
            throw SamlUtils.samlException("SAML content is in-response-to [{}] but expected one of {} ", response.getInResponseTo(), allowedSamlRequestIds);
        }
    }

    protected String getStatusCodeMessage(Status status) {
        StatusCode firstLevel = status.getStatusCode();
        StatusCode subLevel = firstLevel.getStatusCode();
        StringBuilder sb = new StringBuilder();
        if ("urn:oasis:names:tc:SAML:2.0:status:Requester".equals(firstLevel.getValue())) {
            sb.append("The SAML IdP did not grant the request. It indicated that the Elastic Stack side sent something invalid (");
        } else if ("urn:oasis:names:tc:SAML:2.0:status:Responder".equals(firstLevel.getValue())) {
            sb.append("The request could not be granted due to an error in the SAML IDP side (");
        } else if ("urn:oasis:names:tc:SAML:2.0:status:VersionMismatch".equals(firstLevel.getValue())) {
            sb.append("The request could not be granted because the SAML IDP doesn't support SAML 2.0 (");
        } else {
            sb.append("The request could not be granted, the SAML IDP responded with a non-standard Status code (");
        }
        sb.append(firstLevel.getValue()).append(").");
        if (this.getMessage(status) != null) {
            sb.append(" Message: [").append(this.getMessage(status)).append("]");
        }
        if (this.getDetail(status) != null) {
            sb.append(" Detail: [").append(this.getDetail(status)).append("]");
        }
        if (null != subLevel) {
            sb.append(" Specific status code which might indicate what the issue is: [").append(subLevel.getValue()).append("]");
        }
        return sb.toString();
    }

    protected void checkResponseDestination(StatusResponseType response, String spConfiguredUrl) {
        if (!spConfiguredUrl.equals(response.getDestination()) && (response.isSigned() || Strings.hasText((String)response.getDestination()))) {
            throw SamlUtils.samlException("SAML response " + response.getID() + " is for destination " + response.getDestination() + " but this realm uses " + spConfiguredUrl, new Object[0]);
        }
    }

    protected void checkStatus(Status status) {
        if (status == null || status.getStatusCode() == null) {
            throw SamlUtils.samlException("SAML Response has no status code", new Object[0]);
        }
        if (!this.isSuccess(status)) {
            throw SamlUtils.samlException("SAML Response is not a 'success' response: {}", this.getStatusCodeMessage(status));
        }
    }

    protected boolean isSuccess(Status status) {
        return "urn:oasis:names:tc:SAML:2.0:status:Success".equals(status.getStatusCode().getValue());
    }

    private String getMessage(Status status) {
        StatusMessage sm = status.getStatusMessage();
        return sm == null ? null : sm.getMessage();
    }

    private String getDetail(Status status) {
        StatusDetail sd = status.getStatusDetail();
        return sd == null ? null : SamlUtils.toString(sd.getDOM());
    }
}

