/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequest
extends AbstractSqlQueryRequest {
    private static final ObjectParser<SqlQueryRequest, Void> PARSER = SqlQueryRequest.objectParser(SqlQueryRequest::new);
    static final ParseField COLUMNAR = new ParseField("columnar", new String[0]);
    static final ParseField FIELD_MULTI_VALUE_LENIENCY = new ParseField("field_multi_value_leniency", new String[0]);
    static final ParseField INDEX_INCLUDE_FROZEN = new ParseField("index_include_frozen", new String[0]);
    static final ParseField BINARY_COMMUNICATION = new ParseField("binary_format", new String[0]);
    private String cursor = "";
    private Boolean columnar = Protocol.COLUMNAR;
    private Boolean binaryCommunication = Protocol.BINARY_COMMUNICATION;
    private boolean fieldMultiValueLeniency = false;
    private boolean indexIncludeFrozen = false;

    public SqlQueryRequest() {
    }

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, QueryBuilder filter, ZoneId zoneId, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, Boolean columnar, String cursor, RequestInfo requestInfo, boolean fieldMultiValueLeniency, boolean indexIncludeFrozen) {
        super(query, params, filter, zoneId, fetchSize, requestTimeout, pageTimeout, requestInfo);
        this.cursor = cursor;
        this.columnar = columnar;
        this.fieldMultiValueLeniency = fieldMultiValueLeniency;
        this.indexIncludeFrozen = indexIncludeFrozen;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (!Strings.hasText(this.query()) && !Strings.hasText(this.cursor)) {
            validationException = ValidateActions.addValidationError("one of [query] or [cursor] is required", validationException);
        }
        return validationException;
    }

    public String cursor() {
        return this.cursor;
    }

    public SqlQueryRequest cursor(String cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("cursor may not be null.");
        }
        this.cursor = cursor;
        return this;
    }

    public Boolean columnar() {
        return this.columnar;
    }

    public SqlQueryRequest columnar(boolean columnar) {
        this.columnar = columnar;
        return this;
    }

    public SqlQueryRequest fieldMultiValueLeniency(boolean leniency) {
        this.fieldMultiValueLeniency = leniency;
        return this;
    }

    public boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    public SqlQueryRequest indexIncludeFrozen(boolean include) {
        this.indexIncludeFrozen = include;
        return this;
    }

    public boolean indexIncludeFrozen() {
        return this.indexIncludeFrozen;
    }

    public SqlQueryRequest binaryCommunication(boolean binaryCommunication) {
        this.binaryCommunication = binaryCommunication;
        return this;
    }

    public Boolean binaryCommunication() {
        return this.binaryCommunication;
    }

    public SqlQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
        this.columnar = in.readOptionalBoolean();
        this.fieldMultiValueLeniency = in.readBoolean();
        this.indexIncludeFrozen = in.readBoolean();
        this.binaryCommunication = in.readOptionalBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cursor);
        out.writeOptionalBoolean(this.columnar);
        out.writeBoolean(this.fieldMultiValueLeniency);
        out.writeBoolean(this.indexIncludeFrozen);
        out.writeOptionalBoolean(this.binaryCommunication);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor, this.columnar, this.fieldMultiValueLeniency, this.indexIncludeFrozen, this.binaryCommunication);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.cursor, ((SqlQueryRequest)obj).cursor) && Objects.equals(this.columnar, ((SqlQueryRequest)obj).columnar) && this.fieldMultiValueLeniency == ((SqlQueryRequest)obj).fieldMultiValueLeniency && this.indexIncludeFrozen == ((SqlQueryRequest)obj).indexIncludeFrozen && this.binaryCommunication == ((SqlQueryRequest)obj).binaryCommunication;
    }

    @Override
    public String getDescription() {
        return "SQL [" + this.query() + "][" + this.filter() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return new org.elasticsearch.xpack.sql.proto.SqlQueryRequest(this.query(), this.params(), this.zoneId(), this.fetchSize(), this.requestTimeout(), this.pageTimeout(), this.filter(), this.columnar(), this.cursor(), this.requestInfo(), this.fieldMultiValueLeniency(), this.indexIncludeFrozen(), this.binaryCommunication()).toXContent(builder, params);
    }

    public static SqlQueryRequest fromXContent(XContentParser parser) {
        SqlQueryRequest request = PARSER.apply(parser, null);
        SqlQueryRequest.validateParams(request.params(), request.mode());
        return request;
    }

    static {
        PARSER.declareString(SqlQueryRequest::cursor, CURSOR);
        PARSER.declareBoolean(SqlQueryRequest::columnar, COLUMNAR);
        PARSER.declareBoolean(SqlQueryRequest::fieldMultiValueLeniency, FIELD_MULTI_VALUE_LENIENCY);
        PARSER.declareBoolean(SqlQueryRequest::indexIncludeFrozen, INDEX_INCLUDE_FROZEN);
        PARSER.declareBoolean(SqlQueryRequest::binaryCommunication, BINARY_COMMUNICATION);
    }
}

