/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Header;
import org.elasticsearch.transport.InboundMessage;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportHandshaker;
import org.elasticsearch.transport.TransportKeepAlive;
import org.elasticsearch.transport.TransportLogger;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;

public class InboundHandler {
    private static final Logger logger = LogManager.getLogger(InboundHandler.class);
    private final ThreadPool threadPool;
    private final OutboundHandler outboundHandler;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final TransportHandshaker handshaker;
    private final TransportKeepAlive keepAlive;
    private final Transport.ResponseHandlers responseHandlers;
    private final Transport.RequestHandlers requestHandlers;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;

    InboundHandler(ThreadPool threadPool, OutboundHandler outboundHandler, NamedWriteableRegistry namedWriteableRegistry, TransportHandshaker handshaker, TransportKeepAlive keepAlive, Transport.RequestHandlers requestHandlers, Transport.ResponseHandlers responseHandlers) {
        this.threadPool = threadPool;
        this.outboundHandler = outboundHandler;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.handshaker = handshaker;
        this.keepAlive = keepAlive;
        this.requestHandlers = requestHandlers;
        this.responseHandlers = responseHandlers;
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    void inboundMessage(TcpChannel channel, InboundMessage message) throws Exception {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        TransportLogger.logInboundMessage(channel, message);
        if (message.isPing()) {
            this.keepAlive.receiveKeepAlive(channel);
        } else {
            this.messageReceived(channel, message);
        }
    }

    private void messageReceived(TcpChannel channel, InboundMessage message) throws IOException {
        InetSocketAddress remoteAddress = channel.getRemoteAddress();
        Header header = message.getHeader();
        assert (!header.needsToReadVariableHeader());
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext existing = threadContext.stashContext();){
            threadContext.setHeaders(header.getHeaders());
            threadContext.putTransient("_remote_address", remoteAddress);
            if (header.isRequest()) {
                this.handleRequest(channel, header, message);
            } else {
                TransportResponseHandler<? extends TransportResponse> theHandler;
                assert (!message.isShortCircuit());
                StreamInput streamInput = this.namedWriteableStream(message.openOrGetStreamInput());
                InboundHandler.assertRemoteVersion(streamInput, header.getVersion());
                long requestId = header.getRequestId();
                TransportResponseHandler<TransportResponse> handler = header.isHandshake() ? this.handshaker.removeHandlerForHandshake(requestId) : ((theHandler = this.responseHandlers.onResponseReceived(requestId, this.messageListener)) == null && header.isError() ? this.handshaker.removeHandlerForHandshake(requestId) : theHandler);
                if (handler != null) {
                    if (header.isError()) {
                        this.handlerResponseError(streamInput, handler);
                    } else {
                        this.handleResponse(remoteAddress, streamInput, handler);
                    }
                    int nextByte = streamInput.read();
                    if (nextByte != -1) {
                        throw new IllegalStateException("Message not fully read (response) for requestId [" + requestId + "], handler [" + handler + "], error [" + header.isError() + "]; resetting");
                    }
                }
            }
        }
    }

    private <T extends TransportRequest> void handleRequest(TcpChannel channel, Header header, InboundMessage message) throws IOException {
        block12: {
            String action = header.getActionName();
            long requestId = header.getRequestId();
            Version version = header.getVersion();
            if (header.isHandshake()) {
                this.messageListener.onRequestReceived(requestId, action);
                assert (!message.isShortCircuit());
                StreamInput stream = this.namedWriteableStream(message.openOrGetStreamInput());
                InboundHandler.assertRemoteVersion(stream, header.getVersion());
                TcpTransportChannel transportChannel = new TcpTransportChannel(this.outboundHandler, channel, action, requestId, version, header.getFeatures(), header.isCompressed(), header.isHandshake(), message.takeBreakerReleaseControl());
                try {
                    this.handshaker.handleHandshake(transportChannel, requestId, stream);
                }
                catch (Exception e) {
                    if (Version.CURRENT.isCompatible(header.getVersion())) {
                        InboundHandler.sendErrorResponse(action, transportChannel, e);
                        break block12;
                    }
                    logger.warn(new ParameterizedMessage("could not send error response to handshake received on [{}] using wire format version [{}], closing channel", (Object)channel, (Object)header.getVersion()), (Throwable)e);
                    channel.close();
                }
            } else {
                TcpTransportChannel transportChannel = new TcpTransportChannel(this.outboundHandler, channel, action, requestId, version, header.getFeatures(), header.isCompressed(), header.isHandshake(), message.takeBreakerReleaseControl());
                try {
                    this.messageListener.onRequestReceived(requestId, action);
                    if (message.isShortCircuit()) {
                        InboundHandler.sendErrorResponse(action, transportChannel, message.getException());
                    } else {
                        StreamInput stream = this.namedWriteableStream(message.openOrGetStreamInput());
                        InboundHandler.assertRemoteVersion(stream, header.getVersion());
                        RequestHandlerRegistry reg = this.requestHandlers.getHandler(action);
                        assert (reg != null);
                        Object request = reg.newRequest(stream);
                        ((TransportMessage)request).remoteAddress(new TransportAddress(channel.getRemoteAddress()));
                        int nextByte = stream.read();
                        if (nextByte != -1) {
                            throw new IllegalStateException("Message not fully read (request) for requestId [" + requestId + "], action [" + action + "], available [" + stream.available() + "]; resetting");
                        }
                        this.threadPool.executor(reg.getExecutor()).execute(new RequestHandler(reg, request, transportChannel));
                    }
                }
                catch (Exception e) {
                    InboundHandler.sendErrorResponse(action, transportChannel, e);
                }
            }
        }
    }

    private static void sendErrorResponse(String actionName, TransportChannel transportChannel, Exception e) {
        try {
            transportChannel.sendResponse(e);
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)actionName), (Throwable)inner);
        }
    }

    private <T extends TransportResponse> void handleResponse(InetSocketAddress remoteAddress, StreamInput stream, final TransportResponseHandler<T> handler) {
        TransportResponse response;
        try {
            response = (TransportResponse)handler.read(stream);
            response.remoteAddress(new TransportAddress(remoteAddress));
        }
        catch (Exception e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response from handler [" + handler.getClass().getName() + "]", e));
            return;
        }
        this.threadPool.executor(handler.executor()).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                InboundHandler.this.handleException(handler, new ResponseHandlerFailureTransportException(e));
            }

            @Override
            protected void doRun() {
                handler.handleResponse(response);
            }
        });
    }

    private void handlerResponseError(StreamInput stream, TransportResponseHandler<?> handler) {
        Object error;
        try {
            error = stream.readException();
        }
        catch (Exception e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, (Throwable)error);
    }

    private void handleException(TransportResponseHandler<?> handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException(error.getMessage(), error);
        }
        RemoteTransportException rtx = (RemoteTransportException)error;
        this.threadPool.executor(handler.executor()).execute(() -> {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("failed to handle exception response [{}]", (Object)handler), (Throwable)e);
            }
        });
    }

    private StreamInput namedWriteableStream(StreamInput delegate) {
        return new NamedWriteableAwareStreamInput(delegate, this.namedWriteableRegistry);
    }

    static void assertRemoteVersion(StreamInput in, Version version) {
        assert (version.equals(in.getVersion())) : "Stream version [" + in.getVersion() + "] does not match version [" + version + "]";
    }

    private static class RequestHandler<T extends TransportRequest>
    extends AbstractRunnable {
        private final RequestHandlerRegistry<T> reg;
        private final T request;
        private final TransportChannel transportChannel;

        RequestHandler(RequestHandlerRegistry<T> reg, T request, TransportChannel transportChannel) {
            this.reg = reg;
            this.request = request;
            this.transportChannel = transportChannel;
        }

        @Override
        protected void doRun() throws Exception {
            this.reg.processMessageReceived(this.request, this.transportChannel);
        }

        @Override
        public boolean isForceExecution() {
            return this.reg.isForceExecution();
        }

        @Override
        public void onFailure(Exception e) {
            InboundHandler.sendErrorResponse(this.reg.getAction(), this.transportChannel, e);
        }
    }
}

