/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.Snapshot;

public class UpdateIndexShardSnapshotStatusRequest
extends MasterNodeRequest<UpdateIndexShardSnapshotStatusRequest> {
    private final Snapshot snapshot;
    private final ShardId shardId;
    private final SnapshotsInProgress.ShardSnapshotStatus status;

    public UpdateIndexShardSnapshotStatusRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = new Snapshot(in);
        this.shardId = new ShardId(in);
        this.status = new SnapshotsInProgress.ShardSnapshotStatus(in);
    }

    public UpdateIndexShardSnapshotStatusRequest(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
        this.snapshot = snapshot;
        this.shardId = shardId;
        this.status = status;
        this.masterNodeTimeout = TimeValue.timeValueNanos(Long.MAX_VALUE);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.snapshot.writeTo(out);
        this.shardId.writeTo(out);
        this.status.writeTo(out);
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public SnapshotsInProgress.ShardSnapshotStatus status() {
        return this.status;
    }

    public String toString() {
        return this.snapshot + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateIndexShardSnapshotStatusRequest that = (UpdateIndexShardSnapshotStatusRequest)o;
        return this.snapshot.equals(that.snapshot) && this.shardId.equals(that.shardId) && this.status.equals(that.status);
    }

    public int hashCode() {
        return Objects.hash(this.snapshot, this.shardId, this.status);
    }
}

