/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;

public final class FetchVersionPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!context.version() || context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        int lastReaderId = -1;
        NumericDocValues versions = null;
        for (SearchHit hit : hits) {
            int readerId = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
            LeafReaderContext subReaderContext = context.searcher().getIndexReader().leaves().get(readerId);
            if (lastReaderId != readerId) {
                versions = subReaderContext.reader().getNumericDocValues("_version");
                lastReaderId = readerId;
            }
            int docId = hit.docId() - subReaderContext.docBase;
            long version = -1L;
            if (versions != null && versions.advanceExact(docId)) {
                version = versions.longValue();
            }
            hit.version(version < 0L ? -1L : version);
        }
    }
}

