/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class AbstractRangeAggregatorFactory<R extends RangeAggregator.Range>
extends ValuesSourceAggregatorFactory {
    private final InternalRange.Factory<?, ?> rangeFactory;
    private final R[] ranges;
    private final boolean keyed;
    private final String aggregationTypeName;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder, String aggregationName) {
        builder.register(aggregationName, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), RangeAggregator::new);
    }

    public AbstractRangeAggregatorFactory(String name, String aggregationTypeName, ValuesSourceConfig config, R[] ranges, boolean keyed, InternalRange.Factory<?, ?> rangeFactory, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.ranges = ranges;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.aggregationTypeName = aggregationTypeName;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new RangeAggregator.Unmapped(this.name, this.ranges, this.keyed, this.config.format(), searchContext, parent, this.rangeFactory, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config, this.aggregationTypeName);
        if (!(aggregatorSupplier instanceof RangeAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected RangeAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((RangeAggregatorSupplier)aggregatorSupplier).build(this.name, this.factories, (ValuesSource.Numeric)this.config.getValuesSource(), this.config.format(), this.rangeFactory, (RangeAggregator.Range[])this.ranges, this.keyed, searchContext, parent, cardinality, metadata);
    }
}

