/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationSupplier;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateRangeHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public final class DateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final ExtendedBounds extendedBounds;
    private final Rounding rounding;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("date_histogram", List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), DateHistogramAggregator::new);
        builder.register("date_histogram", CoreValuesSourceType.RANGE, DateRangeHistogramAggregator::new);
    }

    public DateHistogramAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, boolean keyed, long minDocCount, Rounding rounding, ExtendedBounds extendedBounds, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.rounding = rounding;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config, "date_histogram");
        if (!(aggregatorSupplier instanceof DateHistogramAggregationSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected DateHistogramAggregationSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        Rounding.Prepared preparedRounding = this.config.getValuesSource().roundingPreparer(this.queryShardContext.getIndexReader()).apply(this.rounding);
        return ((DateHistogramAggregationSupplier)aggregatorSupplier).build(this.name, this.factories, this.rounding, preparedRounding, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.config, searchContext, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new DateHistogramAggregator(this.name, this.factories, this.rounding, null, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }
}

