/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public abstract class AggregatorBase
extends Aggregator {
    public static final int DEFAULT_WEIGHT = 5120;
    protected final String name;
    protected final Aggregator parent;
    protected final SearchContext context;
    private final Map<String, Object> metadata;
    protected final Aggregator[] subAggregators;
    protected BucketCollector collectableSubAggregators;
    private Map<String, Aggregator> subAggregatorbyName;
    private final CircuitBreakerService breakerService;
    private long requestBytesUsed;

    protected AggregatorBase(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, CardinalityUpperBound subAggregatorCardinality, Map<String, Object> metadata) throws IOException {
        this.name = name;
        this.metadata = metadata;
        this.parent = parent;
        this.context = context;
        this.breakerService = context.bigArrays().breakerService();
        assert (factories != null) : "sub-factories provided to BucketAggregator must not be null, use AggragatorFactories.EMPTY instead";
        this.subAggregators = factories.createSubAggregators(context, this, subAggregatorCardinality);
        context.addReleasable(this, SearchContext.Lifetime.PHASE);
        final SearchShardTarget shardTarget = context.shardTarget();
        this.collectableSubAggregators = new BucketCollector(){

            void badState() {
                throw new QueryPhaseExecutionException(shardTarget, "preCollection not called on new Aggregator before use", null);
            }

            @Override
            public LeafBucketCollector getLeafCollector(LeafReaderContext reader) {
                this.badState();
                assert (false);
                return null;
            }

            @Override
            public void preCollection() throws IOException {
                this.badState();
            }

            @Override
            public void postCollection() throws IOException {
                this.badState();
            }

            @Override
            public ScoreMode scoreMode() {
                this.badState();
                return ScoreMode.COMPLETE;
            }
        };
        this.addRequestCircuitBreakerBytes(5120L);
    }

    public final Function<byte[], Number> pointReaderIfAvailable(ValuesSourceConfig config) {
        if (this.context.query() != null && this.context.query().getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        if (this.parent != null) {
            return null;
        }
        return config.getPointReaderOrNull();
    }

    protected long addRequestCircuitBreakerBytes(long bytes) {
        if (bytes > 0L) {
            this.breakerService.getBreaker("request").addEstimateBytesAndMaybeBreak(bytes, "<agg [" + this.name + "]>");
        } else {
            this.breakerService.getBreaker("request").addWithoutBreaking(bytes);
        }
        this.requestBytesUsed += bytes;
        return this.requestBytesUsed;
    }

    @Override
    public ScoreMode scoreMode() {
        for (Aggregator agg : this.subAggregators) {
            if (!agg.scoreMode().needsScores()) continue;
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    protected abstract LeafBucketCollector getLeafCollector(LeafReaderContext var1, LeafBucketCollector var2) throws IOException;

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        this.preGetSubLeafCollectors();
        LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
        return this.getLeafCollector(ctx, sub);
    }

    protected void preGetSubLeafCollectors() throws IOException {
    }

    protected void doPreCollection() throws IOException {
    }

    @Override
    public final void preCollection() throws IOException {
        List<Aggregator> collectors = Arrays.asList(this.subAggregators);
        this.collectableSubAggregators = MultiBucketCollector.wrap(collectors);
        this.doPreCollection();
        this.collectableSubAggregators.preCollection();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Aggregator parent() {
        return this.parent;
    }

    public Aggregator[] subAggregators() {
        return this.subAggregators;
    }

    @Override
    public Aggregator subAggregator(String aggName) {
        if (this.subAggregatorbyName == null) {
            this.subAggregatorbyName = new HashMap<String, Aggregator>(this.subAggregators.length);
            for (int i = 0; i < this.subAggregators.length; ++i) {
                this.subAggregatorbyName.put(this.subAggregators[i].name(), this.subAggregators[i]);
            }
        }
        return this.subAggregatorbyName.get(aggName);
    }

    @Override
    public SearchContext context() {
        return this.context;
    }

    @Override
    public final void postCollection() throws IOException {
        this.doPostCollection();
        this.collectableSubAggregators.postCollection();
    }

    @Override
    public void close() {
        try {
            this.doClose();
        }
        finally {
            this.breakerService.getBreaker("request").addWithoutBreaking(-this.requestBytesUsed);
        }
    }

    protected void doClose() {
    }

    protected void doPostCollection() throws IOException {
    }

    protected final InternalAggregations buildEmptySubAggregations() {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        for (Aggregator aggregator : this.subAggregators) {
            aggs.add(aggregator.buildEmptyAggregation());
        }
        return InternalAggregations.from(aggs);
    }

    public String toString() {
        return this.name;
    }
}

