/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;

public final class RestReloadSecureSettingsAction
extends BaseRestHandler {
    static final ObjectParser<NodesReloadSecureSettingsRequest, String> PARSER = new ObjectParser("reload_secure_settings", NodesReloadSecureSettingsRequest::new);

    @Override
    public String getName() {
        return "nodes_reload_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_nodes/reload_secure_settings"), new RestHandler.Route(RestRequest.Method.POST, "/_nodes/{nodeId}/reload_secure_settings")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        final NodesReloadSecureSettingsRequestBuilder nodesRequestBuilder = (NodesReloadSecureSettingsRequestBuilder)((NodesReloadSecureSettingsRequestBuilder)client.admin().cluster().prepareReloadSecureSettings().setTimeout(request.param("timeout"))).setNodesIds(nodesIds);
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                NodesReloadSecureSettingsRequest nodesRequest = PARSER.parse((XContentParser)parser, (String)null);
                nodesRequestBuilder.setSecureStorePassword(nodesRequest.getSecureSettingsPassword());
            }
        });
        return channel -> nodesRequestBuilder.execute(new RestBuilderListener<NodesReloadSecureSettingsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesReloadSecureSettingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, this.channel.request());
                builder.endObject();
                ((NodesReloadSecureSettingsRequest)nodesRequestBuilder.request()).closePassword();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static {
        PARSER.declareString((request, value) -> request.setSecureStorePassword(new SecureString(value.toCharArray())), new ParseField("secure_settings_password", new String[0]));
    }
}

