/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class NodeService
implements Closeable {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final MonitorService monitorService;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final PluginsService pluginService;
    private final CircuitBreakerService circuitBreakerService;
    private final IngestService ingestService;
    private final SettingsFilter settingsFilter;
    private final ScriptService scriptService;
    private final HttpServerTransport httpServerTransport;
    private final ResponseCollectorService responseCollectorService;
    private final SearchTransportService searchTransportService;
    private final IndexingPressure indexingPressure;
    private final Discovery discovery;

    NodeService(Settings settings, ThreadPool threadPool, MonitorService monitorService, Discovery discovery, TransportService transportService, IndicesService indicesService, PluginsService pluginService, CircuitBreakerService circuitBreakerService, ScriptService scriptService, @Nullable HttpServerTransport httpServerTransport, IngestService ingestService, ClusterService clusterService, SettingsFilter settingsFilter, ResponseCollectorService responseCollectorService, SearchTransportService searchTransportService, IndexingPressure indexingPressure) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.monitorService = monitorService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.discovery = discovery;
        this.pluginService = pluginService;
        this.circuitBreakerService = circuitBreakerService;
        this.httpServerTransport = httpServerTransport;
        this.ingestService = ingestService;
        this.settingsFilter = settingsFilter;
        this.scriptService = scriptService;
        this.responseCollectorService = responseCollectorService;
        this.searchTransportService = searchTransportService;
        this.indexingPressure = indexingPressure;
        clusterService.addStateApplier(ingestService);
    }

    public NodeInfo info(boolean settings, boolean os, boolean process, boolean jvm, boolean threadPool, boolean transport, boolean http, boolean plugin, boolean ingest, boolean indices) {
        return new NodeInfo(Version.CURRENT, Build.CURRENT, this.transportService.getLocalNode(), settings ? this.settingsFilter.filter(this.settings) : null, os ? this.monitorService.osService().info() : null, process ? this.monitorService.processService().info() : null, jvm ? this.monitorService.jvmService().info() : null, threadPool ? this.threadPool.info() : null, transport ? this.transportService.info() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.info()) : null, plugin ? (this.pluginService == null ? null : this.pluginService.info()) : null, ingest ? (this.ingestService == null ? null : this.ingestService.info()) : null, indices ? this.indicesService.getTotalIndexingBufferBytes() : null);
    }

    public NodeStats stats(CommonStatsFlags indices, boolean os, boolean process, boolean jvm, boolean threadPool, boolean fs, boolean transport, boolean http, boolean circuitBreaker, boolean script, boolean discoveryStats, boolean ingest, boolean adaptiveSelection, boolean scriptCache, boolean indexingPressure) {
        return new NodeStats(this.transportService.getLocalNode(), System.currentTimeMillis(), indices.anySet() ? this.indicesService.stats(indices) : null, os ? this.monitorService.osService().stats() : null, process ? this.monitorService.processService().stats() : null, jvm ? this.monitorService.jvmService().stats() : null, threadPool ? this.threadPool.stats() : null, fs ? this.monitorService.fsService().stats() : null, transport ? this.transportService.stats() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.stats()) : null, circuitBreaker ? this.circuitBreakerService.stats() : null, script ? this.scriptService.stats() : null, discoveryStats ? this.discovery.stats() : null, ingest ? this.ingestService.stats() : null, adaptiveSelection ? this.responseCollectorService.getAdaptiveStats(this.searchTransportService.getPendingSearchRequests()) : null, scriptCache ? this.scriptService.cacheStats() : null, indexingPressure ? this.indexingPressure.stats() : null);
    }

    public IngestService getIngestService() {
        return this.ingestService;
    }

    public MonitorService getMonitorService() {
        return this.monitorService;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(new Closeable[]{this.indicesService});
    }

    public boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.indicesService.awaitClose(timeout, timeUnit);
    }
}

