/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import com.carrotsearch.hppc.ObjectHashSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class IndicesRequestCache
implements RemovalListener<Key, BytesReference>,
Closeable {
    private static final Logger logger = LogManager.getLogger(IndicesRequestCache.class);
    public static final Setting<Boolean> INDEX_CACHE_REQUEST_ENABLED_SETTING = Setting.boolSetting("index.requests.cache.enable", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE = Setting.memorySizeSetting("indices.requests.cache.size", "1%", Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_CACHE_QUERY_EXPIRE = Setting.positiveTimeSetting("indices.requests.cache.expire", new TimeValue(0L), Setting.Property.NodeScope);
    private final ConcurrentMap<CleanupKey, Boolean> registeredClosedListeners = ConcurrentCollections.newConcurrentMap();
    private final Set<CleanupKey> keysToClean = ConcurrentCollections.newConcurrentSet();
    private final ByteSizeValue size;
    private final TimeValue expire;
    private final Cache<Key, BytesReference> cache;

    IndicesRequestCache(Settings settings) {
        this.size = INDICES_CACHE_QUERY_SIZE.get(settings);
        this.expire = INDICES_CACHE_QUERY_EXPIRE.exists(settings) ? INDICES_CACHE_QUERY_EXPIRE.get(settings) : null;
        long sizeInBytes = this.size.getBytes();
        CacheBuilder<Key, BytesReference> cacheBuilder = CacheBuilder.builder().setMaximumWeight(sizeInBytes).weigher((k, v) -> k.ramBytesUsed() + v.ramBytesUsed()).removalListener(this);
        if (this.expire != null) {
            cacheBuilder.setExpireAfterAccess(this.expire);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }

    void clear(CacheEntity entity) {
        this.keysToClean.add(new CleanupKey(entity, null));
        this.cleanCache();
    }

    @Override
    public void onRemoval(RemovalNotification<Key, BytesReference> notification) {
        notification.getKey().entity.onRemoval(notification);
    }

    BytesReference getOrCompute(CacheEntity cacheEntity, CheckedSupplier<BytesReference, IOException> loader, DirectoryReader reader, BytesReference cacheKey, Supplier<String> cacheKeyRenderer) throws Exception {
        assert (reader.getReaderCacheHelper() != null);
        Key key = new Key(cacheEntity, reader.getReaderCacheHelper().getKey(), cacheKey);
        Loader cacheLoader = new Loader(cacheEntity, loader);
        BytesReference value = this.cache.computeIfAbsent(key, cacheLoader);
        if (cacheLoader.isLoaded()) {
            Boolean previous;
            CleanupKey cleanupKey;
            key.entity.onMiss();
            if (logger.isTraceEnabled()) {
                logger.trace("Cache miss for reader version [{}] and request:\n {}", (Object)reader.getVersion(), (Object)cacheKeyRenderer.get());
            }
            if (!this.registeredClosedListeners.containsKey(cleanupKey = new CleanupKey(cacheEntity, reader.getReaderCacheHelper().getKey())) && (previous = this.registeredClosedListeners.putIfAbsent(cleanupKey, Boolean.TRUE)) == null) {
                ElasticsearchDirectoryReader.addReaderCloseListener(reader, cleanupKey);
            }
        } else {
            key.entity.onHit();
            if (logger.isTraceEnabled()) {
                logger.trace("Cache hit for reader version [{}] and request:\n {}", (Object)reader.getVersion(), (Object)cacheKeyRenderer.get());
            }
        }
        return value;
    }

    void invalidate(CacheEntity cacheEntity, DirectoryReader reader, BytesReference cacheKey) {
        assert (reader.getReaderCacheHelper() != null);
        this.cache.invalidate(new Key(cacheEntity, reader.getReaderCacheHelper().getKey(), cacheKey));
    }

    synchronized void cleanCache() {
        ObjectHashSet currentKeysToClean = new ObjectHashSet();
        ObjectHashSet currentFullClean = new ObjectHashSet();
        currentKeysToClean.clear();
        currentFullClean.clear();
        Iterator<Object> iterator = this.keysToClean.iterator();
        while (iterator.hasNext()) {
            CleanupKey cleanupKey = iterator.next();
            iterator.remove();
            if (cleanupKey.readerCacheKey == null || !cleanupKey.entity.isOpen()) {
                currentFullClean.add(cleanupKey.entity.getCacheIdentity());
                continue;
            }
            currentKeysToClean.add((Object)cleanupKey);
        }
        if (!currentKeysToClean.isEmpty() || !currentFullClean.isEmpty()) {
            iterator = this.cache.keys().iterator();
            while (iterator.hasNext()) {
                Key key = (Key)iterator.next();
                if (currentFullClean.contains(key.entity.getCacheIdentity())) {
                    iterator.remove();
                    continue;
                }
                if (!currentKeysToClean.contains((Object)new CleanupKey(key.entity, key.readerCacheKey))) continue;
                iterator.remove();
            }
        }
        this.cache.refresh();
    }

    int count() {
        return this.cache.count();
    }

    int numRegisteredCloseListeners() {
        return this.registeredClosedListeners.size();
    }

    private class CleanupKey
    implements IndexReader.ClosedListener {
        final CacheEntity entity;
        final IndexReader.CacheKey readerCacheKey;

        private CleanupKey(CacheEntity entity, IndexReader.CacheKey readerCacheKey) {
            this.entity = entity;
            this.readerCacheKey = readerCacheKey;
        }

        @Override
        public void onClose(IndexReader.CacheKey cacheKey) {
            Boolean remove = (Boolean)IndicesRequestCache.this.registeredClosedListeners.remove(this);
            if (remove != null) {
                IndicesRequestCache.this.keysToClean.add(this);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CleanupKey that = (CleanupKey)o;
            if (!Objects.equals(this.readerCacheKey, that.readerCacheKey)) {
                return false;
            }
            return this.entity.getCacheIdentity().equals(that.entity.getCacheIdentity());
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + Objects.hashCode(this.readerCacheKey);
            return result;
        }
    }

    static interface CacheEntity
    extends Accountable {
        public void onCached(Key var1, BytesReference var2);

        public boolean isOpen();

        public Object getCacheIdentity();

        public void onHit();

        public void onMiss();

        public void onRemoval(RemovalNotification<Key, BytesReference> var1);
    }

    static class Key
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Key.class);
        public final CacheEntity entity;
        public final IndexReader.CacheKey readerCacheKey;
        public final BytesReference value;

        Key(CacheEntity entity, IndexReader.CacheKey readerCacheKey, BytesReference value) {
            this.entity = entity;
            this.readerCacheKey = Objects.requireNonNull(readerCacheKey);
            this.value = value;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + this.entity.ramBytesUsed() + (long)this.value.length();
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!Objects.equals(this.readerCacheKey, key.readerCacheKey)) {
                return false;
            }
            if (!this.entity.getCacheIdentity().equals(key.entity.getCacheIdentity())) {
                return false;
            }
            return this.value.equals(key.value);
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + this.readerCacheKey.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    private static class Loader
    implements CacheLoader<Key, BytesReference> {
        private final CacheEntity entity;
        private final CheckedSupplier<BytesReference, IOException> loader;
        private boolean loaded;

        Loader(CacheEntity entity, CheckedSupplier<BytesReference, IOException> loader) {
            this.entity = entity;
            this.loader = loader;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public BytesReference load(Key key) throws Exception {
            BytesReference value = this.loader.get();
            this.entity.onCached(key, value);
            this.loaded = true;
            return value;
        }
    }
}

