/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;

public class DistanceFeatureQueryBuilder
extends AbstractQueryBuilder<DistanceFeatureQueryBuilder> {
    public static final String NAME = "distance_feature";
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField ORIGIN_FIELD = new ParseField("origin", new String[0]);
    private static final ParseField PIVOT_FIELD = new ParseField("pivot", new String[0]);
    private final String field;
    private final Origin origin;
    private final String pivot;
    private static final ConstructingObjectParser<DistanceFeatureQueryBuilder, Void> PARSER = new ConstructingObjectParser("distance_feature", false, args -> new DistanceFeatureQueryBuilder((String)args[0], (Origin)args[1], (String)args[2]));

    public DistanceFeatureQueryBuilder(String field, Origin origin, String pivot) {
        this.field = Objects.requireNonNull(field);
        this.origin = Objects.requireNonNull(origin);
        this.pivot = Objects.requireNonNull(pivot);
    }

    public static DistanceFeatureQueryBuilder fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(ORIGIN_FIELD.getPreferredName(), this.origin.origin);
        builder.field(PIVOT_FIELD.getPreferredName(), this.pivot);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public DistanceFeatureQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.origin = new Origin(in);
        this.pivot = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        this.origin.writeTo(out);
        out.writeString(this.pivot);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("Can't run [distance_feature] query on unmapped fields!");
        }
        Object originObj = this.origin.origin();
        if (fieldType instanceof DateFieldMapper.DateFieldType) {
            long originLong = ((DateFieldMapper.DateFieldType)fieldType).parseToLong(originObj, true, null, null, context::nowInMillis);
            TimeValue pivotVal = TimeValue.parseTimeValue(this.pivot, DistanceFeatureQueryBuilder.class.getSimpleName() + ".pivot");
            if (((DateFieldMapper.DateFieldType)fieldType).resolution() == DateFieldMapper.Resolution.MILLISECONDS) {
                return LongPoint.newDistanceFeatureQuery(this.field, this.boost, originLong, pivotVal.getMillis());
            }
            return LongPoint.newDistanceFeatureQuery(this.field, this.boost, originLong, pivotVal.getNanos());
        }
        if (fieldType instanceof GeoPointFieldMapper.GeoPointFieldType) {
            GeoPoint originGeoPoint;
            if (originObj instanceof GeoPoint) {
                originGeoPoint = (GeoPoint)originObj;
            } else if (originObj instanceof String) {
                originGeoPoint = GeoUtils.parseFromString((String)originObj);
            } else {
                throw new IllegalArgumentException("Illegal type [" + this.origin.getClass() + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
            }
            double pivotDouble = DistanceUnit.DEFAULT.parse(this.pivot, DistanceUnit.DEFAULT);
            return LatLonPoint.newDistanceFeatureQuery(this.field, this.boost, originGeoPoint.lat(), originGeoPoint.lon(), pivotDouble);
        }
        throw new IllegalArgumentException("Illegal data type of [" + fieldType.typeName() + "]![" + NAME + "] query can only be run on a date, date_nanos or geo_point field type!");
    }

    String fieldName() {
        return this.field;
    }

    Origin origin() {
        return this.origin;
    }

    String pivot() {
        return this.pivot;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.field, this.origin, this.pivot);
    }

    @Override
    protected boolean doEquals(DistanceFeatureQueryBuilder other) {
        return this.field.equals(other.field) && Objects.equals(this.origin, other.origin) && this.pivot.equals(other.pivot);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), x$0 -> Origin.originFromXContent(x$0), ORIGIN_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_STRING_OR_NUMBER);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PIVOT_FIELD);
        DistanceFeatureQueryBuilder.declareStandardFields(PARSER);
    }

    public static class Origin {
        private final Object origin;

        public Origin(Long origin) {
            this.origin = Objects.requireNonNull(origin);
        }

        public Origin(String origin) {
            this.origin = Objects.requireNonNull(origin);
        }

        public Origin(GeoPoint origin) {
            this.origin = Objects.requireNonNull(origin);
        }

        private static Origin originFromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Origin(parser.longValue());
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Origin(parser.text());
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                return new Origin(GeoUtils.parseGeoPoint(parser));
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                return new Origin(GeoUtils.parseGeoPoint(parser));
            }
            throw new ParsingException(parser.getTokenLocation(), "Illegal type while parsing [origin]! Must be [number] or [string] for date and date_nanos fields; or [string], [array], [object] for geo_point fields!", new Object[0]);
        }

        private Origin(StreamInput in) throws IOException {
            this.origin = in.readGenericValue();
        }

        private void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.origin);
        }

        Object origin() {
            return this.origin;
        }

        public final boolean equals(Object other) {
            if (!(other instanceof Origin)) {
                return false;
            }
            Object otherOrigin = ((Origin)other).origin();
            return this.origin().equals(otherOrigin);
        }

        public int hashCode() {
            return Objects.hash(this.origin);
        }

        public String toString() {
            return this.origin.toString();
        }
    }
}

