/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.DocValueFormat;

public abstract class MappedFieldType {
    private final String name;
    private final boolean docValues;
    private final boolean isIndexed;
    private final TextSearchInfo textSearchInfo;
    private float boost;
    private NamedAnalyzer indexAnalyzer;
    private boolean eagerGlobalOrdinals;
    private Map<String, String> meta;

    public MappedFieldType(String name, boolean isIndexed, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        this.setBoost(1.0f);
        this.name = Objects.requireNonNull(name);
        this.isIndexed = isIndexed;
        this.docValues = hasDocValues;
        this.textSearchInfo = Objects.requireNonNull(textSearchInfo);
        this.meta = meta;
    }

    public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
        throw new IllegalArgumentException("Fielddata is not supported on field [" + this.name() + "] of type [" + this.typeName() + "]");
    }

    public abstract String typeName();

    public String familyTypeName() {
        return this.typeName();
    }

    public String name() {
        return this.name;
    }

    public float boost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public NamedAnalyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void setIndexAnalyzer(NamedAnalyzer analyzer) {
        this.indexAnalyzer = analyzer;
    }

    public Object valueForDisplay(Object value) {
        return value;
    }

    public boolean isSearchable() {
        return this.isIndexed;
    }

    @Nullable
    public Function<byte[], Number> pointReaderIfPossible() {
        return null;
    }

    public boolean isAggregatable() {
        try {
            this.fielddataBuilder("");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public abstract Query termQuery(Object var1, @Nullable QueryShardContext var2);

    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : values) {
            builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery(builder.build());
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
        throw new IllegalArgumentException("Field [" + this.name + "] of type [" + this.typeName() + "] does not support range queries");
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
        throw new IllegalArgumentException("Can only use fuzzy queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use prefix queries on keyword, text and wildcard fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use wildcard queries on keyword, text and wildcard fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public Query regexpQuery(String value, int flags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        throw new QueryShardException(context, "Can only use regexp queries on keyword and text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]", new Object[0]);
    }

    public abstract Query existsQuery(QueryShardContext var1);

    public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
        throw new IllegalArgumentException("Can only use phrase queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
        throw new IllegalArgumentException("Can only use phrase queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
        throw new IllegalArgumentException("Can only use phrase prefix queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
        throw new IllegalArgumentException("Can only use span prefix queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource intervals(String query, int max_gaps, boolean ordered, NamedAnalyzer analyzer, boolean prefix) throws IOException {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name + "] which is of type [" + this.typeName() + "]");
    }

    public Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateMathParser, QueryRewriteContext context) throws IOException {
        return Relation.INTERSECTS;
    }

    protected final void failIfNoDocValues() {
        if (!this.hasDocValues()) {
            throw new IllegalArgumentException("Can't load fielddata on [" + this.name() + "] because fielddata is unsupported on fields of type [" + this.typeName() + "]. Use doc values instead.");
        }
    }

    protected final void failIfNotIndexed() {
        if (!this.isIndexed) {
            throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is not indexed.");
        }
    }

    public boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    public void setEagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
    }

    public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
        }
        if (timeZone != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
        }
        return DocValueFormat.RAW;
    }

    public static Term extractTerm(Query termQuery) {
        TermInSetQuery tisQuery;
        PrefixCodedTerms terms;
        while (termQuery instanceof BoostQuery) {
            termQuery = ((BoostQuery)termQuery).getQuery();
        }
        if (termQuery instanceof TypeFieldMapper.TypesQuery) {
            assert (((TypeFieldMapper.TypesQuery)termQuery).getTerms().length == 1);
            return new Term("_type", ((TypeFieldMapper.TypesQuery)termQuery).getTerms()[0]);
        }
        if (termQuery instanceof TermInSetQuery && (terms = (tisQuery = (TermInSetQuery)termQuery).getTermData()).size() == 1L) {
            PrefixCodedTerms.TermIterator it = terms.iterator();
            BytesRef term = it.next();
            return new Term(it.field(), term);
        }
        if (!(termQuery instanceof TermQuery)) {
            throw new IllegalArgumentException("Cannot extract a term from a query of type " + termQuery.getClass() + ": " + termQuery);
        }
        return ((TermQuery)termQuery).getTerm();
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public void updateMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public TextSearchInfo getTextSearchInfo() {
        return this.textSearchInfo;
    }

    public static enum Relation {
        WITHIN,
        INTERSECTS,
        DISJOINT;

    }
}

