/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public final class KeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    private int ignoreAbove;
    private boolean splitQueriesOnWhitespace;
    private String nullValue;

    protected KeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, int ignoreAbove, boolean splitQueriesOnWhitespace, String nullValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) <= 0);
        this.ignoreAbove = ignoreAbove;
        this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
        this.nullValue = nullValue;
    }

    public int ignoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected KeywordFieldMapper clone() {
        return (KeywordFieldMapper)super.clone();
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            try (TokenStream ts = normalizer.tokenStream(this.name(), value);){
                CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
                ts.reset();
                if (!ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + normalizer + " and input \"" + value + "\"");
                }
                String newValue = termAtt.toString();
                if (ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + normalizer + " and input \"" + value + "\"");
                }
                ts.end();
                value = newValue;
            }
        }
        BytesRef binaryValue = new BytesRef(value);
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            KeywordField field = new KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
            context.doc().add(field);
            if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        KeywordFieldMapper k = (KeywordFieldMapper)other;
        if (!Objects.equals(this.fieldType().indexAnalyzer(), k.fieldType().indexAnalyzer())) {
            conflicts.add("mapper [" + this.name() + "] has different [normalizer]");
        }
        if (!Objects.equals(this.mappedFieldType.getTextSearchInfo().getSimilarity(), k.fieldType().getTextSearchInfo().getSimilarity())) {
            conflicts.add("mapper [" + this.name() + "] has different [similarity]");
        }
        this.ignoreAbove = k.ignoreAbove;
        this.splitQueriesOnWhitespace = k.splitQueriesOnWhitespace;
        this.fieldType().setBoost(k.fieldType().boost());
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType.indexOptions() != IndexOptions.NONE && (includeDefaults || this.fieldType.indexOptions() != Defaults.FIELD_TYPE.indexOptions())) {
            builder.field("index_options", KeywordFieldMapper.indexOptionToString(this.fieldType.indexOptions()));
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (includeDefaults || this.ignoreAbove != Integer.MAX_VALUE) {
            builder.field("ignore_above", this.ignoreAbove);
        }
        if (includeDefaults || this.fieldType.omitNorms() != Defaults.FIELD_TYPE.omitNorms()) {
            builder.field("norms", !this.fieldType.omitNorms());
        }
        if (includeDefaults || this.fieldType().eagerGlobalOrdinals()) {
            builder.field("eager_global_ordinals", this.fieldType().eagerGlobalOrdinals());
        }
        if (this.fieldType().normalizer() != null && this.fieldType().normalizer() != Lucene.KEYWORD_ANALYZER) {
            builder.field("normalizer", this.fieldType().normalizer().name());
        } else if (includeDefaults) {
            builder.field("normalizer", "default");
        }
        if (this.fieldType().getTextSearchInfo().getSimilarity() != null) {
            builder.field("similarity", this.fieldType().getTextSearchInfo().getSimilarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "BM25");
        }
        if (includeDefaults || this.splitQueriesOnWhitespace) {
            builder.field("split_queries_on_whitespace", this.splitQueriesOnWhitespace);
        }
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        boolean hasNorms;

        public KeywordFieldType(String name, boolean hasDocValues, FieldType fieldType, boolean eagerGlobalOrdinals, NamedAnalyzer normalizer, NamedAnalyzer searchAnalyzer, SimilarityProvider similarity, Map<String, String> meta, float boost) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, hasDocValues, new TextSearchInfo(fieldType, similarity, searchAnalyzer, searchAnalyzer), meta);
            this.hasNorms = !fieldType.omitNorms();
            this.setEagerGlobalOrdinals(eagerGlobalOrdinals);
            this.setIndexAnalyzer(normalizer);
            this.setBoost(boost);
        }

        public KeywordFieldType(String name, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            super(name, isSearchable, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public KeywordFieldType(String name) {
            this(name, true, Defaults.FIELD_TYPE, false, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, null, Collections.emptyMap(), 1.0f);
        }

        public KeywordFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.indexAnalyzer();
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            if (!this.hasNorms) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(CoreValuesSourceType.BYTES);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }
    }

    public static class KeywordField
    extends Field {
        public KeywordField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }

        public KeywordField(String field, BytesRef term) {
            super(field, term, (IndexableFieldType)Defaults.FIELD_TYPE);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final String NULL_VALUE;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;
        public static final boolean EAGER_GLOBAL_ORDINALS = false;
        public static final boolean SPLIT_QUERIES_ON_WHITESPACE = false;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                TypeParsers.checkNull(propName, propNode);
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_above")) {
                    builder.ignoreAbove(XContentMapValues.nodeIntegerValue(propNode, -1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("norms")) {
                    TypeParsers.parseNorms(builder, name, propNode);
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(propNode, "eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("normalizer")) {
                    if (propNode != null) {
                        builder.normalizer(parserContext.getIndexAnalyzers(), propNode.toString());
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("split_queries_on_whitespace")) {
                    builder.splitQueriesOnWhitespace(XContentMapValues.nodeBooleanValue(propNode, "split_queries_on_whitespace"));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("similarity")) continue;
                SimilarityProvider similarityProvider = TypeParsers.resolveSimilarity(parserContext, name, propNode.toString());
                builder.similarity(similarityProvider);
                iterator.remove();
            }
            TypeParsers.parseField(builder, name, node, parserContext);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected int ignoreAbove = Integer.MAX_VALUE;
        private IndexAnalyzers indexAnalyzers;
        private String normalizerName = "default";
        private boolean eagerGlobalOrdinals = false;
        private boolean splitQueriesOnWhitespace = false;
        private SimilarityProvider similarity;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public Builder omitNorms(boolean omitNorms) {
            this.fieldType.setOmitNorms(omitNorms);
            return (Builder)this.builder;
        }

        public void similarity(SimilarityProvider similarity) {
            this.similarity = similarity;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            if (ignoreAbove < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got " + ignoreAbove);
            }
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        @Override
        public Builder indexOptions(IndexOptions indexOptions) {
            if (indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) > 0) {
                throw new IllegalArgumentException("The [keyword] field does not support positions, got [index_options]=" + FieldMapper.indexOptionToString(indexOptions));
            }
            return (Builder)super.indexOptions(indexOptions);
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            return (Builder)this.builder;
        }

        public Builder splitQueriesOnWhitespace(boolean splitQueriesOnWhitespace) {
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
            return (Builder)this.builder;
        }

        public Builder normalizer(IndexAnalyzers indexAnalyzers, String name) {
            this.indexAnalyzers = indexAnalyzers;
            this.normalizerName = name;
            return (Builder)this.builder;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return (Builder)this.builder;
        }

        private KeywordFieldType buildFieldType(Mapper.BuilderContext context) {
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer searchAnalyzer = Lucene.KEYWORD_ANALYZER;
            if (this.normalizerName == null || !"default".equals(this.normalizerName)) {
                normalizer = this.indexAnalyzers.getNormalizer(this.normalizerName);
                if (normalizer == null) {
                    throw new MapperParsingException("normalizer [" + this.normalizerName + "] not found for field [" + this.name + "]");
                }
                searchAnalyzer = this.splitQueriesOnWhitespace ? this.indexAnalyzers.getWhitespaceNormalizer(this.normalizerName) : normalizer;
            } else if (this.splitQueriesOnWhitespace) {
                searchAnalyzer = new NamedAnalyzer("whitespace", AnalyzerScope.INDEX, (Analyzer)new WhitespaceAnalyzer());
            }
            return new KeywordFieldType(this.buildFullName(context), this.hasDocValues, this.fieldType, this.eagerGlobalOrdinals, normalizer, searchAnalyzer, this.similarity, this.meta, this.boost);
        }

        @Override
        public KeywordFieldMapper build(Mapper.BuilderContext context) {
            return new KeywordFieldMapper(this.name, this.fieldType, this.buildFieldType(context), this.ignoreAbove, this.splitQueriesOnWhitespace, this.nullValue, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

