/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class IpFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(IpFieldMapper.class));
    public static final String CONTENT_TYPE = "ip";
    private Explicit<Boolean> ignoreMalformed;
    private final InetAddress nullValue;

    private IpFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, InetAddress nullValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.nullValue = nullValue;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected IpFieldMapper clone() {
        return (IpFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        InetAddress address;
        Object addressAsObject = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (addressAsObject == null) {
            addressAsObject = this.nullValue;
        }
        if (addressAsObject == null) {
            return;
        }
        String addressAsString = addressAsObject.toString();
        if (addressAsObject instanceof InetAddress) {
            address = (InetAddress)addressAsObject;
        } else {
            try {
                address = InetAddresses.forString(addressAsString);
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    context.addIgnoredField(this.fieldType().name());
                    return;
                }
                throw e;
            }
        }
        if (this.fieldType().isSearchable()) {
            context.doc().add((IndexableField)new InetAddressPoint(this.fieldType().name(), address));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        } else if (this.fieldType.stored() || this.fieldType().isSearchable()) {
            this.createFieldNamesField(context);
        }
        if (this.fieldType.stored()) {
            context.doc().add(new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        IpFieldMapper mergeWith = (IpFieldMapper)other;
        if (mergeWith.nullValue != this.nullValue) {
            conflicts.add("mapper [" + this.name() + "] has different [null_value] values");
        }
        if (mergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = mergeWith.ignoreMalformed;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.nullValue != null) {
            builder.field("null_value", InetAddresses.toAddrString(this.nullValue));
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        public IpFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
        }

        public IpFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        private InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String term;
            this.failIfNotIndexed();
            if (value instanceof InetAddress) {
                return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            if ((term = value.toString()).contains("/")) {
                Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
                return InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)cidr.v1(), (int)cidr.v2());
            }
            InetAddress address = InetAddresses.forString(term);
            return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString(value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])addresses);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            InetAddress upper;
            InetAddress lower;
            this.failIfNotIndexed();
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = this.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = this.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(IpScriptDocValues::new, CoreValuesSourceType.IP);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.IP;
        }

        public static final class IpScriptDocValues
        extends ScriptDocValues<String> {
            private final SortedSetDocValues in;
            private long[] ords = new long[0];
            private int count;

            public IpScriptDocValues(SortedSetDocValues in) {
                this.in = in;
            }

            @Override
            public void setNextDocId(int docId) throws IOException {
                this.count = 0;
                if (this.in.advanceExact(docId)) {
                    long ord = this.in.nextOrd();
                    while (ord != -1L) {
                        this.ords = ArrayUtil.grow(this.ords, this.count + 1);
                        this.ords[this.count++] = ord;
                        ord = this.in.nextOrd();
                    }
                }
            }

            public String getValue() {
                if (this.count == 0) {
                    return null;
                }
                return this.get(0);
            }

            @Override
            public String get(int index) {
                try {
                    BytesRef encoded = this.in.lookupOrd(this.ords[index]);
                    InetAddress address = InetAddressPoint.decode((byte[])Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length));
                    return InetAddresses.toAddrString(address);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return this.count;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    try {
                        builder.nullValue(InetAddresses.forString(propNode.toString()));
                    }
                    catch (Exception e) {
                        DEPRECATION_LOGGER.deprecatedAndMaybeLog("ip_field_null_value", "Error parsing [{}] as IP in [null_value] on field [{}]; [null_value] will be ignored", propNode.toString(), name);
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder::addMultiField, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private Boolean ignoreMalformed;
        private InetAddress nullValue;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        public Builder nullValue(InetAddress nullValue) {
            this.nullValue = nullValue;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        @Override
        public IpFieldMapper build(Mapper.BuilderContext context) {
            return new IpFieldMapper(this.name, this.fieldType, new IpFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, this.meta), this.ignoreMalformed(context), this.nullValue, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setDimensions(1, 4);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

