/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.QueryShardContext;

public final class IgnoredFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_ignored";
    public static final String CONTENT_TYPE = "_ignored";

    private IgnoredFieldMapper() {
        super(Defaults.FIELD_TYPE, IgnoredFieldType.INSTANCE);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        for (String field : context.getIgnoredFields()) {
            context.doc().add(new Field("_ignored", field, (IndexableFieldType)this.fieldType));
        }
    }

    @Override
    protected String contentType() {
        return "_ignored";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Defaults {
        public static final String NAME = "_ignored";
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    public static final class IgnoredFieldType
    extends StringFieldType {
        public static final IgnoredFieldType INSTANCE = new IgnoredFieldType();

        private IgnoredFieldType() {
            super("_ignored", true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_ignored";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermRangeQuery(this.name(), null, null, true, true);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder();
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            return new IgnoredFieldMapper();
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder> {
        public Builder() {
            super("_ignored", Defaults.FIELD_TYPE);
        }

        @Override
        public IgnoredFieldMapper build(Mapper.BuilderContext context) {
            return new IgnoredFieldMapper();
        }
    }
}

