/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.document.HalfFloatPoint;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.plain.LeafDoubleFieldData;
import org.elasticsearch.index.fielddata.plain.LeafLongFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class SortedNumericIndexFieldData
extends IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;
    protected final Index index;
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;

    public SortedNumericIndexFieldData(Index index, String fieldName, IndexNumericFieldData.NumericType numericType) {
        this.index = index;
        this.fieldName = fieldName;
        this.numericType = Objects.requireNonNull(numericType);
        this.valuesSourceType = numericType.getValuesSourceType();
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public final void clear() {
    }

    @Override
    public final Index index() {
        return this.index;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return this.numericType == IndexNumericFieldData.NumericType.HALF_FLOAT;
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toMilliSeconds));
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds));
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public LeafNumericFieldData load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        String field = this.fieldName;
        switch (this.numericType) {
            case HALF_FLOAT: {
                return new SortedNumericHalfFloatFieldData(reader, field);
            }
            case FLOAT: {
                return new SortedNumericFloatFieldData(reader, field);
            }
            case DOUBLE: {
                return new SortedNumericDoubleFieldData(reader, field);
            }
            case DATE_NANOSECONDS: {
                return new NanoSecondFieldData(reader, field, this.numericType);
            }
        }
        return new SortedNumericLongFieldData(reader, field, this.numericType);
    }

    static final class SortedNumericHalfFloatFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericHalfFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                NumericDocValues single = DocValues.unwrapSingleton(raw);
                if (single != null) {
                    return FieldData.singleton(new SingleHalfFloatValues(single));
                }
                return new MultiHalfFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class SortedNumericFloatFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                NumericDocValues single = DocValues.unwrapSingleton(raw);
                if (single != null) {
                    return FieldData.singleton(new SingleFloatValues(single));
                }
                return new MultiFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class SortedNumericDoubleFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericDoubleFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                return FieldData.sortableLongBitsToDoubles(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    public final class NanoSecondFieldData
    extends LeafLongFieldData {
        private final LeafReader reader;
        private final String fieldName;

        NanoSecondFieldData(LeafReader reader, String fieldName, IndexNumericFieldData.NumericType numericType) {
            super(0L, numericType);
            this.reader = reader;
            this.fieldName = fieldName;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return SortedNumericIndexFieldData.convertNumeric(this.getLongValuesAsNanos(), DateUtils::toMilliSeconds);
        }

        public SortedNumericDocValues getLongValuesAsNanos() {
            try {
                return DocValues.getSortedNumeric(this.reader, this.fieldName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }
    }

    static final class SortedNumericLongFieldData
    extends LeafLongFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericLongFieldData(LeafReader reader, String field, IndexNumericFieldData.NumericType numericType) {
            super(0L, numericType);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            try {
                return DocValues.getSortedNumeric(this.reader, this.field);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class MultiFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)this.in.nextValue());
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleFloatValues(NumericDocValues in) {
            this.in = in;
        }

        @Override
        public double doubleValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)this.in.longValue());
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    static final class MultiHalfFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiHalfFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.nextValue()));
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleHalfFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleHalfFloatValues(NumericDocValues in) {
            this.in = in;
        }

        @Override
        public double doubleValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.longValue()));
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final IndexNumericFieldData.NumericType numericType;

        public Builder(IndexNumericFieldData.NumericType numericType) {
            this.numericType = numericType;
        }

        public SortedNumericIndexFieldData build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            String fieldName = fieldType.name();
            return new SortedNumericIndexFieldData(indexSettings.getIndex(), fieldName, this.numericType);
        }
    }
}

