/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.nio.ByteBuffer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureObjects;
import org.elasticsearch.common.bytes.AbstractBytesReference;
import org.elasticsearch.common.bytes.BytesReference;

public class ByteBufferReference
extends AbstractBytesReference {
    private final ByteBuffer buffer;
    private final int length;

    ByteBufferReference(ByteBuffer buffer) {
        this.buffer = buffer.slice();
        this.length = buffer.remaining();
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public int indexOf(byte marker, int from) {
        int remainingBytes = Math.max(this.length - from, 0);
        FutureObjects.checkFromIndexSize(from, remainingBytes, this.length);
        if (this.buffer.hasArray()) {
            int startIndex = from + this.buffer.arrayOffset();
            int endIndex = startIndex + remainingBytes;
            byte[] array = this.buffer.array();
            for (int i = startIndex; i < endIndex; ++i) {
                if (array[i] != marker) continue;
                return i - this.buffer.arrayOffset();
            }
            return -1;
        }
        return super.indexOf(marker, from);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        FutureObjects.checkFromIndexSize(from, length, this.length);
        this.buffer.position(from);
        this.buffer.limit(from + length);
        ByteBufferReference newByteBuffer = new ByteBufferReference(this.buffer);
        this.buffer.position(0);
        this.buffer.limit(this.length);
        return newByteBuffer;
    }

    @Override
    public BytesRef toBytesRef() {
        if (this.buffer.hasArray()) {
            return new BytesRef(this.buffer.array(), this.buffer.arrayOffset(), this.length);
        }
        byte[] copy = new byte[this.length];
        this.buffer.get(copy, 0, this.length);
        return new BytesRef(copy);
    }

    @Override
    public long ramBytesUsed() {
        return this.buffer.capacity();
    }
}

