/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.Version;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.CountedCollector;
import org.elasticsearch.action.search.ExpandSearchPhase;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.SearchContextId;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.transport.Transport;

final class FetchSearchPhase
extends SearchPhase {
    private final AtomicArray<FetchSearchResult> fetchResults;
    private final SearchPhaseController searchPhaseController;
    private final AtomicArray<SearchPhaseResult> queryResults;
    private final BiFunction<InternalSearchResponse, String, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final Logger logger;
    private final SearchPhaseResults<SearchPhaseResult> resultConsumer;
    private final SearchProgressListener progressListener;
    private final ClusterState clusterState;

    FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, SearchPhaseController searchPhaseController, SearchPhaseContext context, ClusterState clusterState) {
        this(resultConsumer, searchPhaseController, context, clusterState, (response, scrollId) -> new ExpandSearchPhase(context, (InternalSearchResponse)response, (String)scrollId));
    }

    FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, SearchPhaseController searchPhaseController, SearchPhaseContext context, ClusterState clusterState, BiFunction<InternalSearchResponse, String, SearchPhase> nextPhaseFactory) {
        super("fetch");
        if (context.getNumShards() != resultConsumer.getNumShards()) {
            throw new IllegalStateException("number of shards must match the length of the query results but doesn't:" + context.getNumShards() + "!=" + resultConsumer.getNumShards());
        }
        this.fetchResults = new AtomicArray(resultConsumer.getNumShards());
        this.searchPhaseController = searchPhaseController;
        this.queryResults = resultConsumer.getAtomicArray();
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.logger = context.getLogger();
        this.resultConsumer = resultConsumer;
        this.progressListener = context.getTask().getProgressListener();
        this.clusterState = clusterState;
    }

    @Override
    public void run() {
        this.context.execute(new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                FetchSearchPhase.this.innerRun();
            }

            @Override
            public void onFailure(Exception e) {
                FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
            }
        });
    }

    private void innerRun() throws IOException {
        String scrollId;
        int numShards = this.context.getNumShards();
        boolean isScrollSearch = this.context.getRequest().scroll() != null;
        List<SearchPhaseResult> phaseResults = this.queryResults.asList();
        if (isScrollSearch) {
            boolean includeContextUUID = this.clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_7_7_0);
            scrollId = TransportSearchHelper.buildScrollId(this.queryResults, includeContextUUID);
        } else {
            scrollId = null;
        }
        SearchPhaseController.ReducedQueryPhase reducedQueryPhase = this.resultConsumer.reduce();
        boolean queryAndFetchOptimization = this.queryResults.length() == 1;
        Runnable finishPhase = () -> this.moveToNextPhase(this.searchPhaseController, scrollId, reducedQueryPhase, queryAndFetchOptimization ? this.queryResults : this.fetchResults);
        if (queryAndFetchOptimization) {
            assert (phaseResults.isEmpty() || phaseResults.get(0).fetchResult() != null) : "phaseResults empty [" + phaseResults.isEmpty() + "], single result: " + phaseResults.get(0).fetchResult();
            finishPhase.run();
        } else {
            ScoreDoc[] scoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
            IntArrayList[] docIdsToLoad = this.searchPhaseController.fillDocIdsToLoad(numShards, scoreDocs);
            if (scoreDocs.length == 0) {
                phaseResults.stream().map(SearchPhaseResult::queryResult).forEach(this::releaseIrrelevantSearchContext);
                finishPhase.run();
            } else {
                ScoreDoc[] lastEmittedDocPerShard = isScrollSearch ? this.searchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, numShards) : null;
                CountedCollector<FetchSearchResult> counter = new CountedCollector<FetchSearchResult>(r -> this.fetchResults.set(r.getShardIndex(), (FetchSearchResult)r), docIdsToLoad.length, finishPhase, this.context);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    IntArrayList entry = docIdsToLoad[i];
                    SearchPhaseResult queryResult = this.queryResults.get(i);
                    if (entry == null) {
                        if (queryResult != null) {
                            this.releaseIrrelevantSearchContext(queryResult.queryResult());
                            this.progressListener.notifyFetchResult(i);
                        }
                        counter.countDown();
                        continue;
                    }
                    SearchShardTarget searchShardTarget = queryResult.getSearchShardTarget();
                    Transport.Connection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                    ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult.queryResult().getContextId(), i, entry, lastEmittedDocPerShard, searchShardTarget.getOriginalIndices());
                    this.executeFetch(i, searchShardTarget, counter, fetchSearchRequest, queryResult.queryResult(), connection);
                }
            }
        }
    }

    protected ShardFetchSearchRequest createFetchRequest(SearchContextId contextId, int index, IntArrayList entry, ScoreDoc[] lastEmittedDocPerShard, OriginalIndices originalIndices) {
        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard != null ? lastEmittedDocPerShard[index] : null;
        return new ShardFetchSearchRequest(originalIndices, contextId, entry, lastEmittedDoc);
    }

    private void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final CountedCollector<FetchSearchResult> counter, final ShardFetchSearchRequest fetchSearchRequest, final QuerySearchResult querySearchResult, Transport.Connection connection) {
        this.context.getSearchTransport().sendExecuteFetch(connection, fetchSearchRequest, this.context.getTask(), new SearchActionListener<FetchSearchResult>(shardTarget, shardIndex){

            @Override
            public void innerOnResponse(FetchSearchResult result) {
                try {
                    FetchSearchPhase.this.progressListener.notifyFetchResult(shardIndex);
                    counter.onResult(result);
                }
                catch (Exception e) {
                    FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    FetchSearchPhase.this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute fetch phase", (Object)fetchSearchRequest.contextId()), (Throwable)e);
                    FetchSearchPhase.this.progressListener.notifyFetchFailure(shardIndex, shardTarget, e);
                    counter.onFailure(shardIndex, shardTarget, e);
                }
                finally {
                    FetchSearchPhase.this.releaseIrrelevantSearchContext(querySearchResult);
                }
            }
        });
    }

    private void releaseIrrelevantSearchContext(QuerySearchResult queryResult) {
        if (this.context.getRequest().scroll() == null && queryResult.hasSearchContext()) {
            try {
                SearchShardTarget searchShardTarget = queryResult.getSearchShardTarget();
                Transport.Connection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                this.context.sendReleaseSearchContext(queryResult.getContextId(), connection, searchShardTarget.getOriginalIndices());
            }
            catch (Exception e) {
                this.context.getLogger().trace("failed to release context", (Throwable)e);
            }
        }
    }

    private void moveToNextPhase(SearchPhaseController searchPhaseController, String scrollId, SearchPhaseController.ReducedQueryPhase reducedQueryPhase, AtomicArray<? extends SearchPhaseResult> fetchResultsArr) {
        InternalSearchResponse internalResponse = searchPhaseController.merge(this.context.getRequest().scroll() != null, reducedQueryPhase, fetchResultsArr.asList(), fetchResultsArr::get);
        this.context.executeNextPhase(this, this.nextPhaseFactory.apply(internalResponse, scrollId));
    }
}

