/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.store.IndexInputStats;
import org.elasticsearch.index.store.SearchableSnapshotDirectory;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotShardStats;
import org.elasticsearch.xpack.searchablesnapshots.action.AbstractTransportSearchableSnapshotsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.SearchableSnapshotsStatsRequest;
import org.elasticsearch.xpack.searchablesnapshots.action.SearchableSnapshotsStatsResponse;

public class TransportSearchableSnapshotsStatsAction
extends AbstractTransportSearchableSnapshotsAction<SearchableSnapshotsStatsRequest, SearchableSnapshotsStatsResponse, SearchableSnapshotShardStats> {
    @Inject
    public TransportSearchableSnapshotsStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
        super("cluster:monitor/xpack/searchable_snapshots/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, SearchableSnapshotsStatsRequest::new, "management", indicesService, licenseState);
    }

    protected SearchableSnapshotShardStats readShardResult(StreamInput in) throws IOException {
        return new SearchableSnapshotShardStats(in);
    }

    protected SearchableSnapshotsStatsResponse newResponse(SearchableSnapshotsStatsRequest request, int totalShards, int successfulShards, int failedShards, List<SearchableSnapshotShardStats> shardsStats, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new SearchableSnapshotsStatsResponse(shardsStats, totalShards, successfulShards, failedShards, shardFailures);
    }

    protected SearchableSnapshotsStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new SearchableSnapshotsStatsRequest(in);
    }

    @Override
    protected SearchableSnapshotShardStats executeShardOperation(SearchableSnapshotsStatsRequest request, ShardRouting shardRouting, SearchableSnapshotDirectory directory) {
        return new SearchableSnapshotShardStats(shardRouting, directory.getSnapshotId(), directory.getIndexId(), directory.getStats().entrySet().stream().map(entry -> TransportSearchableSnapshotsStatsAction.toCacheIndexInputStats((String)entry.getKey(), (IndexInputStats)entry.getValue())).collect(Collectors.toList()));
    }

    private static SearchableSnapshotShardStats.CacheIndexInputStats toCacheIndexInputStats(String fileName, IndexInputStats inputStats) {
        return new SearchableSnapshotShardStats.CacheIndexInputStats(fileName, inputStats.getFileLength(), inputStats.getOpened().sum(), inputStats.getClosed().sum(), TransportSearchableSnapshotsStatsAction.toCounter(inputStats.getForwardSmallSeeks()), TransportSearchableSnapshotsStatsAction.toCounter(inputStats.getBackwardSmallSeeks()), TransportSearchableSnapshotsStatsAction.toCounter(inputStats.getForwardLargeSeeks()), TransportSearchableSnapshotsStatsAction.toCounter(inputStats.getBackwardLargeSeeks()), TransportSearchableSnapshotsStatsAction.toCounter(inputStats.getContiguousReads()), TransportSearchableSnapshotsStatsAction.toCounter(inputStats.getNonContiguousReads()), TransportSearchableSnapshotsStatsAction.toCounter(inputStats.getCachedBytesRead()), TransportSearchableSnapshotsStatsAction.toTimedCounter(inputStats.getCachedBytesWritten()), TransportSearchableSnapshotsStatsAction.toTimedCounter(inputStats.getDirectBytesRead()), TransportSearchableSnapshotsStatsAction.toTimedCounter(inputStats.getOptimizedBytesRead()));
    }

    private static SearchableSnapshotShardStats.Counter toCounter(IndexInputStats.Counter counter) {
        return new SearchableSnapshotShardStats.Counter(counter.count(), counter.total(), counter.min(), counter.max());
    }

    private static SearchableSnapshotShardStats.TimedCounter toTimedCounter(IndexInputStats.TimedCounter counter) {
        return new SearchableSnapshotShardStats.TimedCounter(counter.count(), counter.total(), counter.min(), counter.max(), counter.totalNanoseconds());
    }
}

