/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.xpack.searchablesnapshots.action.RepositoryStatsNodeResponse;

public class RepositoryStatsResponse
extends BaseNodesResponse<RepositoryStatsNodeResponse>
implements ToXContentObject {
    private final RepositoryStats globalStats = RepositoryStatsResponse.computeGlobalStats(this.getNodes());

    public RepositoryStatsResponse(ClusterName clusterName, List<RepositoryStatsNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public RepositoryStatsResponse(StreamInput in) throws IOException {
        super(in);
    }

    private static RepositoryStats computeGlobalStats(List<RepositoryStatsNodeResponse> nodes) {
        if (nodes.isEmpty()) {
            return RepositoryStats.EMPTY_STATS;
        }
        return nodes.stream().map(RepositoryStatsNodeResponse::getRepositoryStats).reduce(RepositoryStats::merge).get();
    }

    protected List<RepositoryStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(RepositoryStatsNodeResponse::new);
    }

    protected void writeNodesTo(StreamOutput out, List<RepositoryStatsNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_all", (Object)this.globalStats.requestCounts);
        builder.startArray("nodes");
        for (RepositoryStatsNodeResponse node : this.getNodes()) {
            node.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

