/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.store.SearchableSnapshotDirectory;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotAction;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsFeatureSet;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotAllocator;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotIndexEventListener;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsConstants;
import org.elasticsearch.xpack.searchablesnapshots.action.ClearSearchableSnapshotsCacheAction;
import org.elasticsearch.xpack.searchablesnapshots.action.RepositoryStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.SearchableSnapshotsStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportClearSearchableSnapshotsCacheAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportMountSearchableSnapshotAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportRepositoryStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportSearchableSnapshotsStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.cache.CacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.NodeEnvironmentCacheCleaner;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestClearSearchableSnapshotsCacheAction;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestMountSearchableSnapshotAction;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestRepositoryStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestSearchableSnapshotsStatsAction;

public class SearchableSnapshots
extends Plugin
implements IndexStorePlugin,
EnginePlugin,
ActionPlugin,
ClusterPlugin {
    public static final Setting<String> SNAPSHOT_REPOSITORY_SETTING = Setting.simpleString((String)"index.store.snapshot.repository_name", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_SNAPSHOT_NAME_SETTING = Setting.simpleString((String)"index.store.snapshot.snapshot_name", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_SNAPSHOT_ID_SETTING = Setting.simpleString((String)"index.store.snapshot.snapshot_uuid", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_INDEX_ID_SETTING = Setting.simpleString((String)"index.store.snapshot.index_uuid", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<Boolean> SNAPSHOT_CACHE_ENABLED_SETTING = Setting.boolSetting((String)"index.store.snapshot.cache.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize});
    public static final Setting<Boolean> SNAPSHOT_CACHE_PREWARM_ENABLED_SETTING = Setting.boolSetting((String)"index.store.snapshot.cache.prewarm.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize});
    public static final Setting<List<String>> SNAPSHOT_CACHE_EXCLUDED_FILE_TYPES_SETTING = Setting.listSetting((String)"index.store.snapshot.cache.excluded_file_types", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope, Setting.Property.NotCopyableOnResize});
    public static final Setting<ByteSizeValue> SNAPSHOT_UNCACHED_CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"index.store.snapshot.uncached_chunk_size", (ByteSizeValue)new ByteSizeValue(-1L, ByteSizeUnit.BYTES), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope, Setting.Property.NotCopyableOnResize});
    private volatile Supplier<RepositoriesService> repositoriesServiceSupplier;
    private final SetOnce<CacheService> cacheService = new SetOnce();
    private final SetOnce<ThreadPool> threadPool = new SetOnce();
    private final Settings settings;
    private final boolean transportClientMode;

    public SearchableSnapshots(Settings settings) {
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public static void ensureValidLicense(XPackLicenseState licenseState) {
        if (!licenseState.isAllowed(XPackLicenseState.Feature.SEARCHABLE_SNAPSHOTS)) {
            throw LicenseUtils.newComplianceException((String)"searchable-snapshots");
        }
    }

    public List<Setting<?>> getSettings() {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            return org.elasticsearch.common.collect.List.of((Object[])new Setting[]{SNAPSHOT_REPOSITORY_SETTING, SNAPSHOT_SNAPSHOT_NAME_SETTING, SNAPSHOT_SNAPSHOT_ID_SETTING, SNAPSHOT_INDEX_ID_SETTING, SNAPSHOT_CACHE_ENABLED_SETTING, SNAPSHOT_CACHE_PREWARM_ENABLED_SETTING, SNAPSHOT_CACHE_EXCLUDED_FILE_TYPES_SETTING, SNAPSHOT_UNCACHED_CHUNK_SIZE_SETTING, CacheService.SNAPSHOT_CACHE_SIZE_SETTING, CacheService.SNAPSHOT_CACHE_RANGE_SIZE_SETTING});
        }
        return org.elasticsearch.common.collect.List.of();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry registry, IndexNameExpressionResolver resolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            CacheService cacheService = new CacheService(new NodeEnvironmentCacheCleaner(nodeEnvironment), this.settings);
            this.cacheService.set((Object)cacheService);
            this.repositoriesServiceSupplier = repositoriesServiceSupplier;
            this.threadPool.set((Object)threadPool);
            return org.elasticsearch.common.collect.List.of((Object)((Object)cacheService));
        }
        this.repositoriesServiceSupplier = () -> {
            assert (false) : "searchable snapshots are disabled";
            return null;
        };
        return org.elasticsearch.common.collect.List.of();
    }

    public Collection<Module> createGuiceModules() {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            if (this.transportClientMode) {
                return Collections.emptyList();
            }
            return Collections.singleton(b -> XPackPlugin.bindFeatureSet((Binder)b, SearchableSnapshotsFeatureSet.class));
        }
        return org.elasticsearch.common.collect.List.of();
    }

    public void onIndexModule(IndexModule indexModule) {
        if (SearchableSnapshotsConstants.isSearchableSnapshotStore((Settings)indexModule.getSettings())) {
            indexModule.addIndexEventListener((IndexEventListener)new SearchableSnapshotIndexEventListener());
        }
    }

    public Map<String, IndexStorePlugin.DirectoryFactory> getDirectoryFactories() {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            return org.elasticsearch.common.collect.Map.of((Object)"snapshot", (indexSettings, shardPath) -> {
                RepositoriesService repositories = this.repositoriesServiceSupplier.get();
                assert (repositories != null);
                CacheService cache = (CacheService)((Object)((Object)this.cacheService.get()));
                assert (cache != null);
                ThreadPool threadPool = (ThreadPool)this.threadPool.get();
                assert (threadPool != null);
                return SearchableSnapshotDirectory.create(repositories, cache, indexSettings, shardPath, System::nanoTime, threadPool);
            });
        }
        return org.elasticsearch.common.collect.Map.of();
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (SearchableSnapshotsConstants.isSearchableSnapshotStore((Settings)indexSettings.getSettings()) && !indexSettings.getSettings().getAsBoolean("index.frozen", Boolean.valueOf(false)).booleanValue()) {
            return Optional.of(engineConfig -> new ReadOnlyEngine(engineConfig, null, new TranslogStats(), false, Function.identity(), false));
        }
        return Optional.empty();
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            return org.elasticsearch.common.collect.List.of((Object[])new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)SearchableSnapshotsStatsAction.INSTANCE, TransportSearchableSnapshotsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearSearchableSnapshotsCacheAction.INSTANCE, TransportClearSearchableSnapshotsCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MountSearchableSnapshotAction.INSTANCE, TransportMountSearchableSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RepositoryStatsAction.INSTANCE, TransportRepositoryStatsAction.class, new Class[0])});
        }
        return org.elasticsearch.common.collect.List.of();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            return org.elasticsearch.common.collect.List.of((Object[])new RestHandler[]{new RestSearchableSnapshotsStatsAction(), new RestClearSearchableSnapshotsCacheAction(), new RestMountSearchableSnapshotAction(), new RestRepositoryStatsAction()});
        }
        return org.elasticsearch.common.collect.List.of();
    }

    public Map<String, ExistingShardsAllocator> getExistingShardsAllocators() {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            return Collections.singletonMap("searchable_snapshot_allocator", new SearchableSnapshotAllocator());
        }
        return Collections.emptyMap();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOTS_FEATURE_ENABLED) {
            return org.elasticsearch.common.collect.List.of((Object[])SearchableSnapshots.executorBuilders());
        }
        return org.elasticsearch.common.collect.List.of();
    }

    public static ScalingExecutorBuilder[] executorBuilders() {
        return new ScalingExecutorBuilder[]{new ScalingExecutorBuilder("searchable_snapshots_cache_fetch_async", 0, 32, TimeValue.timeValueSeconds((long)30L), "xpack.searchable_snapshots.cache_fetch_async_thread_pool"), new ScalingExecutorBuilder("searchable_snapshots_cache_prewarming", 0, 32, TimeValue.timeValueSeconds((long)30L), "xpack.searchable_snapshots.cache_prewarming_thread_pool")};
    }
}

