/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class SearchableSnapshotAllocator
implements ExistingShardsAllocator {
    public static final String ALLOCATOR_NAME = "searchable_snapshot_allocator";

    public void beforeAllocation(RoutingAllocation allocation) {
    }

    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
    }

    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        AllocateUnassignedDecision allocateUnassignedDecision = SearchableSnapshotAllocator.decideAllocation(allocation, shardRouting);
        assert (allocateUnassignedDecision.isDecisionTaken());
        if (allocateUnassignedDecision.getAllocationDecision() == AllocationDecision.YES) {
            if (shardRouting.primary() && shardRouting.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE) {
                unassignedAllocationHandler.updateUnassigned(shardRouting.unassignedInfo(), (RecoverySource)RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE, allocation.changes());
            }
        } else {
            unassignedAllocationHandler.removeAndIgnore(allocateUnassignedDecision.getAllocationStatus(), allocation.changes());
        }
    }

    private static AllocateUnassignedDecision decideAllocation(RoutingAllocation allocation, ShardRouting shardRouting) {
        assert (shardRouting.unassigned());
        assert (((String)ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.get(allocation.metadata().getIndexSafe(shardRouting.index()).getSettings())).equals(ALLOCATOR_NAME));
        Decision.Type bestDecision = Decision.Type.NO;
        RoutingNode bestNode = null;
        ArrayList<NodeAllocationResult> nodeAllocationResults = allocation.debugDecision() ? new ArrayList<NodeAllocationResult>(allocation.routingNodes().size()) : null;
        for (RoutingNode routingNode : allocation.routingNodes()) {
            Decision decision = allocation.deciders().canAllocate(shardRouting, routingNode, allocation);
            if (decision.type() == Decision.Type.YES || decision.type() == Decision.Type.THROTTLE && bestDecision != Decision.Type.YES) {
                bestDecision = decision.type();
                bestNode = routingNode;
            }
            if (nodeAllocationResults == null) continue;
            nodeAllocationResults.add(new NodeAllocationResult(routingNode.node(), null, decision));
        }
        if (bestDecision == Decision.Type.YES) {
            return AllocateUnassignedDecision.yes((DiscoveryNode)bestNode.node(), null, nodeAllocationResults, (boolean)false);
        }
        if (bestDecision == Decision.Type.THROTTLE) {
            return AllocateUnassignedDecision.throttle(nodeAllocationResults);
        }
        return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.DECIDERS_NO, nodeAllocationResults);
    }

    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (shardRouting.unassigned());
        assert (routingAllocation.debugDecision());
        return SearchableSnapshotAllocator.decideAllocation(routingAllocation, shardRouting);
    }

    public void cleanCaches() {
    }

    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
    }

    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
    }

    public int getNumberOfInFlightFetches() {
        return 0;
    }
}

