/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.checksum;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.index.store.Store;

public class ChecksumBlobContainerIndexInput
extends IndexInput {
    private final byte[] checksum;
    private final long length;
    private long position;

    private ChecksumBlobContainerIndexInput(String name, long length, byte[] checksum, IOContext context) {
        super("ChecksumBlobContainerIndexInput(" + name + ')');
        ChecksumBlobContainerIndexInput.ensureReadOnceChecksumContext(context);
        assert (checksum.length == CodecUtil.footerLength());
        this.checksum = Objects.requireNonNull(checksum);
        assert (length >= (long)this.checksum.length);
        this.length = length;
        this.position = 0L;
    }

    public long length() {
        return this.length;
    }

    public long getFilePointer() {
        return this.position;
    }

    public byte readByte() throws IOException {
        if (this.getFilePointer() >= this.length()) {
            throw new EOFException("seek past EOF");
        }
        return this.checksum[this.checksumPositionOrThrow(this.position++)];
    }

    public void readBytes(byte[] b, int off, int len) throws IOException {
        if (this.getFilePointer() + (long)len > this.length()) {
            throw new EOFException("seek past EOF");
        }
        System.arraycopy(this.checksum, this.checksumPositionOrThrow(this.position), b, off, len);
        this.position += (long)len;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Seeking to negative position: " + pos);
        }
        if (pos > this.length()) {
            throw new EOFException("seek past EOF");
        }
        this.checksumPositionOrThrow(pos);
        this.position = pos;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) {
        assert (false) : "unexpected slicing (" + sliceDescription + ") for " + (Object)((Object)this);
        throw new UnsupportedOperationException();
    }

    public IndexInput clone() {
        assert (false) : "unexpected cloning for " + (Object)((Object)this);
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public String toString() {
        return "ChecksumBlobContainerIndexInput{checksum=" + Arrays.toString(this.checksum) + ", length=" + this.length + ", position=" + this.position + '}';
    }

    private int checksumPositionOrThrow(long pos) {
        long checksumPosition = this.length - (long)this.checksum.length;
        if (pos < checksumPosition) {
            assert (false) : "unexpected read or seek at position [" + pos + "] but checksum starts at [" + checksumPosition + ']';
            throw new IllegalArgumentException("Can't read or seek before footer checksum");
        }
        return Math.toIntExact((long)this.checksum.length - (this.length - pos));
    }

    private static void ensureReadOnceChecksumContext(IOContext context) {
        if (context != Store.READONCE_CHECKSUM) {
            assert (false) : "expected READONCE_CHECKSUM but got " + context;
            throw new IllegalArgumentException("ChecksumBlobContainerIndexInput should only be used with READONCE_CHECKSUM context");
        }
    }

    public static ChecksumBlobContainerIndexInput create(String name, long length, String checksum, IOContext context) throws IOException {
        ByteBuffersDataOutput out = new ByteBuffersDataOutput();
        try (ByteBuffersIndexOutput output = new ByteBuffersIndexOutput(out, "tmp", name);){
            output.writeInt(-1071082520);
            output.writeInt(0);
            output.writeLong(Long.parseLong(checksum, 36));
            output.close();
            ChecksumBlobContainerIndexInput checksumBlobContainerIndexInput = new ChecksumBlobContainerIndexInput(name, length, out.toArrayCopy(), context);
            return checksumBlobContainerIndexInput;
        }
    }
}

