/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.AdapterActionFuture;
import org.elasticsearch.common.collect.Tuple;

class ProgressListenableActionFuture
extends AdapterActionFuture<Long, Long> {
    protected final long start;
    protected final long end;
    private volatile List<Tuple<Long, ActionListener<Long>>> listeners;
    protected volatile long progress;
    private volatile boolean completed;

    ProgressListenableActionFuture(long start, long end) {
        this.start = start;
        this.end = end;
        this.progress = start;
        this.completed = false;
        assert (this.invariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invariant() {
        assert (this.start < this.end) : this.start + " < " + this.end;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (!this.completed || this.listeners == null);
            assert (this.start <= this.progress) : this.start + " <= " + this.progress;
            assert (this.progress <= this.end) : this.progress + " <= " + this.end;
            assert (this.listeners == null || this.listeners.stream().allMatch(listener -> this.progress < (Long)listener.v1()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(long progress) {
        this.ensureNotCompleted();
        if (progress <= this.start) {
            assert (false) : progress + " <= " + this.start;
            throw new IllegalArgumentException("Cannot update progress with a value less than [start=" + this.start + ']');
        }
        if (this.end < progress) {
            assert (false) : this.end + " < " + progress;
            throw new IllegalArgumentException("Cannot update progress with a value greater than [end=" + this.end + ']');
        }
        ArrayList<ActionListener> listenersToExecute = null;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (this.progress < progress) : this.progress + " < " + progress;
            this.progress = progress;
            List<Tuple<Long, ActionListener<Long>>> listeners = this.listeners;
            if (listeners != null) {
                ArrayList<Tuple<Long, ActionListener<Long>>> listenersToKeep = null;
                for (Tuple<Long, ActionListener<Long>> listener2 : listeners) {
                    if (progress < (Long)listener2.v1()) {
                        if (listenersToKeep == null) {
                            listenersToKeep = new ArrayList<Tuple<Long, ActionListener<Long>>>();
                        }
                        listenersToKeep.add(listener2);
                        continue;
                    }
                    if (listenersToExecute == null) {
                        listenersToExecute = new ArrayList<ActionListener>();
                    }
                    listenersToExecute.add((ActionListener)listener2.v2());
                }
                this.listeners = listenersToKeep;
            }
        }
        if (listenersToExecute != null) {
            listenersToExecute.forEach(listener -> this.executeListener((ActionListener<Long>)listener, () -> progress));
        }
        assert (this.invariant());
    }

    public void onResponse(Long result) {
        this.ensureNotCompleted();
        super.onResponse((Object)result);
    }

    public void onFailure(Exception e) {
        this.ensureNotCompleted();
        super.onFailure(e);
    }

    private void ensureNotCompleted() {
        if (this.completed) {
            throw new IllegalStateException("Future is already completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done(boolean success) {
        List<Tuple<Long, ActionListener<Long>>> listenersToExecute;
        super.done(success);
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (this.progress == this.end || !success);
            this.completed = true;
            listenersToExecute = this.listeners;
            this.listeners = null;
        }
        if (listenersToExecute != null) {
            listenersToExecute.stream().map(Tuple::v2).forEach(listener -> this.executeListener((ActionListener<Long>)listener, () -> (Long)this.actionGet(0L)));
        }
        assert (this.invariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<Long> listener, long value) {
        long progress;
        boolean executeImmediate = false;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            progress = this.progress;
            if (this.completed || value <= progress) {
                executeImmediate = true;
            } else {
                List<Tuple<Long, ActionListener<Long>>> listeners = this.listeners;
                if (listeners == null) {
                    listeners = new ArrayList<Tuple<Long, ActionListener<Long>>>();
                }
                listeners.add((Tuple<Long, ActionListener<Long>>)Tuple.tuple((Object)value, listener));
                this.listeners = listeners;
            }
        }
        if (executeImmediate) {
            this.executeListener(listener, this.completed ? () -> (Long)this.actionGet(0L) : () -> progress);
        }
        assert (this.invariant());
    }

    private void executeListener(ActionListener<Long> listener, Supplier<Long> result) {
        try {
            listener.onResponse((Object)result.get());
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected Long convert(Long response) {
        if (response == null || response < this.start || this.end < response) {
            assert (false) : this.start + " < " + response + " < " + this.end;
            throw new IllegalArgumentException("Invalid completion value [start=" + this.start + ",end=" + this.end + ",response=" + response + ']');
        }
        return response;
    }

    public String toString() {
        return "ProgressListenableActionFuture[start=" + this.start + ", end=" + this.end + ", progress=" + this.progress + ", completed=" + this.completed + ", listeners=" + (this.listeners != null ? this.listeners.size() : 0) + ']';
    }
}

