/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregationBuilder;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregator;
import org.elasticsearch.xpack.analytics.ttest.TTestStats;
import org.elasticsearch.xpack.analytics.ttest.TTestStatsBuilder;
import org.elasticsearch.xpack.analytics.ttest.UnpairedTTestState;

public class UnpairedTTestAggregator
extends TTestAggregator<UnpairedTTestState> {
    private final TTestStatsBuilder a;
    private final TTestStatsBuilder b;
    private final boolean homoscedastic;
    private final Supplier<Tuple<Weight, Weight>> weightsSupplier;

    UnpairedTTestAggregator(String name, MultiValuesSource.NumericMultiValuesSource valuesSources, int tails, boolean homoscedastic, Supplier<Tuple<Weight, Weight>> weightsSupplier, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSources, tails, format, context, parent, metadata);
        BigArrays bigArrays = context.bigArrays();
        this.a = new TTestStatsBuilder(bigArrays);
        this.b = new TTestStatsBuilder(bigArrays);
        this.weightsSupplier = weightsSupplier;
        this.homoscedastic = homoscedastic;
    }

    @Override
    protected UnpairedTTestState getState(long bucket) {
        return new UnpairedTTestState(this.a.get(bucket), this.b.get(bucket), this.homoscedastic, this.tails);
    }

    @Override
    protected UnpairedTTestState getEmptyState() {
        return new UnpairedTTestState(new TTestStats(0L, 0.0, 0.0), new TTestStats(0L, 0.0, 0.0), this.homoscedastic, this.tails);
    }

    @Override
    protected long size() {
        return this.a.getSize();
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues docAValues = this.valuesSources.getField(TTestAggregationBuilder.A_FIELD.getPreferredName(), ctx);
        final SortedNumericDoubleValues docBValues = this.valuesSources.getField(TTestAggregationBuilder.B_FIELD.getPreferredName(), ctx);
        final CompensatedSum compSumA = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumOfSqrA = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumB = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumOfSqrB = new CompensatedSum(0.0, 0.0);
        Tuple<Weight, Weight> weights = this.weightsSupplier.get();
        final Bits bitsA = this.getBits(ctx, (Weight)weights.v1());
        final Bits bitsB = this.getBits(ctx, (Weight)weights.v2());
        return new LeafBucketCollectorBase(sub, docAValues){

            private void processValues(int doc, long bucket, SortedNumericDoubleValues docValues, CompensatedSum compSum, CompensatedSum compSumOfSqr, TTestStatsBuilder builder) throws IOException {
                if (docValues.advanceExact(doc)) {
                    int numValues = docValues.docValueCount();
                    for (int i = 0; i < numValues; ++i) {
                        builder.addValue(compSum, compSumOfSqr, bucket, docValues.nextValue());
                    }
                }
            }

            public void collect(int doc, long bucket) throws IOException {
                if (bitsA == null || bitsA.get(doc)) {
                    UnpairedTTestAggregator.this.a.grow(bigArrays, bucket + 1L);
                    this.processValues(doc, bucket, docAValues, compSumA, compSumOfSqrA, UnpairedTTestAggregator.this.a);
                }
                if (bitsB == null || bitsB.get(doc)) {
                    this.processValues(doc, bucket, docBValues, compSumB, compSumOfSqrB, UnpairedTTestAggregator.this.b);
                    UnpairedTTestAggregator.this.b.grow(bigArrays, bucket + 1L);
                }
            }
        };
    }

    private Bits getBits(LeafReaderContext ctx, Weight weight) throws IOException {
        if (weight == null) {
            return null;
        }
        return Lucene.asSequentialAccessBits((int)ctx.reader().maxDoc(), (ScorerSupplier)weight.scorerSupplier(ctx));
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.a, this.b});
    }
}

