/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.ttest.PairedTTestAggregator;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregationBuilder;
import org.elasticsearch.xpack.analytics.ttest.TTestType;
import org.elasticsearch.xpack.analytics.ttest.UnpairedTTestAggregator;

class TTestAggregatorFactory
extends MultiValuesSourceAggregatorFactory {
    private final TTestType testType;
    private final int tails;
    private final Query filterA;
    private final Query filterB;
    private Tuple<Weight, Weight> weights;

    TTestAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, TTestType testType, int tails, QueryBuilder filterA, QueryBuilder filterB, DocValueFormat format, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, format, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.testType = testType;
        this.tails = tails;
        this.filterA = filterA == null ? null : filterA.toQuery(queryShardContext);
        this.filterB = filterB == null ? null : filterB.toQuery(queryShardContext);
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        switch (this.testType) {
            case PAIRED: {
                return new PairedTTestAggregator(this.name, null, this.tails, this.format, searchContext, parent, metadata);
            }
            case HOMOSCEDASTIC: {
                return new UnpairedTTestAggregator(this.name, null, this.tails, true, this::getWeights, this.format, searchContext, parent, metadata);
            }
            case HETEROSCEDASTIC: {
                return new UnpairedTTestAggregator(this.name, null, this.tails, false, this::getWeights, this.format, searchContext, parent, metadata);
            }
        }
        throw new IllegalArgumentException("Unsupported t-test type " + (Object)((Object)this.testType));
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Map<String, ValuesSourceConfig> configs, DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        MultiValuesSource.NumericMultiValuesSource numericMultiVS = new MultiValuesSource.NumericMultiValuesSource(configs, this.queryShardContext);
        if (numericMultiVS.areValuesSourcesEmpty()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        switch (this.testType) {
            case PAIRED: {
                if (this.filterA != null || this.filterB != null) {
                    throw new IllegalArgumentException("Paired t-test doesn't support filters");
                }
                return new PairedTTestAggregator(this.name, numericMultiVS, this.tails, format, searchContext, parent, metadata);
            }
            case HOMOSCEDASTIC: {
                return new UnpairedTTestAggregator(this.name, numericMultiVS, this.tails, true, this::getWeights, format, searchContext, parent, metadata);
            }
            case HETEROSCEDASTIC: {
                return new UnpairedTTestAggregator(this.name, numericMultiVS, this.tails, false, this::getWeights, format, searchContext, parent, metadata);
            }
        }
        throw new IllegalArgumentException("Unsupported t-test type " + (Object)((Object)this.testType));
    }

    public Tuple<Weight, Weight> getWeights() {
        if (this.weights == null) {
            this.weights = new Tuple((Object)this.getWeight(this.filterA), (Object)this.getWeight(this.filterB));
        }
        return this.weights;
    }

    public Weight getWeight(Query filter) {
        if (filter != null) {
            IndexSearcher contextSearcher = this.queryShardContext.searcher();
            try {
                return contextSearcher.createWeight(contextSearcher.rewrite(filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to initialize filter", (Throwable)e);
            }
        }
        return null;
    }

    public String getStatsSubtype() {
        return ((ValuesSourceConfig)this.configs.get(TTestAggregationBuilder.A_FIELD.getPreferredName())).valueSourceType().typeName();
    }
}

