/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.topmetrics;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregator;

public class TopMetricsAggregatorFactory
extends AggregatorFactory {
    public static final Setting<Integer> MAX_BUCKET_SIZE = Setting.intSetting((String)"index.top_metrics_max_size", (int)10, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    private final List<SortBuilder<?>> sortBuilders;
    private final int size;
    private final List<MultiValuesSourceFieldConfig> metricFields;

    public TopMetricsAggregatorFactory(String name, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, List<SortBuilder<?>> sortBuilders, int size, List<MultiValuesSourceFieldConfig> metricFields) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.sortBuilders = sortBuilders;
        this.size = size;
        this.metricFields = metricFields;
    }

    protected TopMetricsAggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        int maxBucketSize = (Integer)MAX_BUCKET_SIZE.get(searchContext.getQueryShardContext().getIndexSettings().getSettings());
        if (this.size > maxBucketSize) {
            throw new IllegalArgumentException("[top_metrics.size] must not be more than [" + maxBucketSize + "] but was [" + this.size + "]. This limit can be set by changing the [" + MAX_BUCKET_SIZE.getKey() + "] index level setting.");
        }
        List<TopMetricsAggregator.MetricSource> metricSources = this.metricFields.stream().map(config -> {
            ValuesSourceConfig resolved = ValuesSourceConfig.resolve((QueryShardContext)searchContext.getQueryShardContext(), (ValueType)ValueType.NUMERIC, (String)config.getFieldName(), (Script)config.getScript(), (Object)config.getMissing(), (ZoneId)config.getTimeZone(), null, (ValuesSourceType)CoreValuesSourceType.NUMERIC);
            return new TopMetricsAggregator.MetricSource(config.getFieldName(), resolved.format(), (ValuesSource.Numeric)resolved.getValuesSource());
        }).collect(Collectors.toList());
        return new TopMetricsAggregator(this.name, searchContext, parent, metadata, this.size, this.sortBuilders.get(0), metricSources);
    }
}

