/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.stringstats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregator;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregatorSupplier;

class StringStatsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final boolean showDistribution;

    StringStatsAggregatorFactory(String name, ValuesSourceConfig config, Boolean showDistribution, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.showDistribution = showDistribution;
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("string_stats", (ValuesSourceType)CoreValuesSourceType.BYTES, StringStatsAggregator::new);
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new StringStatsAggregator(this.name, null, this.showDistribution, this.config.format(), searchContext, parent, metadata);
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config, "string_stats");
        if (!(aggregatorSupplier instanceof StringStatsAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected StringStatsAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((StringStatsAggregatorSupplier)aggregatorSupplier).build(this.name, this.config.getValuesSource(), this.showDistribution, this.config.format(), searchContext, parent, metadata);
    }
}

