/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.stringstats;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;

public class InternalStringStats
extends InternalAggregation {
    private final DocValueFormat format;
    private final boolean showDistribution;
    private final long count;
    private final long totalLength;
    private final int minLength;
    private final int maxLength;
    private final Map<String, Long> charOccurrences;

    public InternalStringStats(String name, long count, long totalLength, int minLength, int maxLength, Map<String, Long> charOccurences, boolean showDistribution, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        this.format = formatter;
        this.showDistribution = showDistribution;
        this.count = count;
        this.totalLength = totalLength;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.charOccurrences = charOccurences;
    }

    public InternalStringStats(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.showDistribution = in.readBoolean();
        this.count = in.readVLong();
        this.totalLength = in.readVLong();
        this.minLength = in.readVInt();
        this.maxLength = in.readVInt();
        this.charOccurrences = in.readMap(StreamInput::readString, StreamInput::readLong);
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeBoolean(this.showDistribution);
        out.writeVLong(this.count);
        out.writeVLong(this.totalLength);
        out.writeVInt(this.minLength);
        out.writeVInt(this.maxLength);
        out.writeMap(this.charOccurrences, StreamOutput::writeString, StreamOutput::writeLong);
    }

    public String getWriteableName() {
        return "string_stats";
    }

    public long getCount() {
        return this.count;
    }

    long getTotalLength() {
        return this.totalLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public double getAvgLength() {
        return (double)this.totalLength / (double)this.count;
    }

    public double getEntropy() {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        for (double p : this.getDistribution().values()) {
            if (!(p > 0.0)) continue;
            double value = p * InternalStringStats.log2(p);
            kahanSummation.add(value);
        }
        return -kahanSummation.value();
    }

    Map<String, Double> getDistribution() {
        return this.charOccurrences.entrySet().stream().sorted((e1, e2) -> ((Long)e2.getValue()).compareTo((Long)e1.getValue())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (double)((Long)e.getValue()).longValue() / (double)this.totalLength, (e1, e2) -> e2, LinkedHashMap::new));
    }

    static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    Map<String, Long> getCharOccurrences() {
        return this.charOccurrences;
    }

    boolean getShowDistribution() {
        return this.showDistribution;
    }

    public String getCountAsString() {
        return this.format.format(this.getCount()).toString();
    }

    public String getMinLengthAsString() {
        return this.format.format((long)this.getMinLength()).toString();
    }

    public String getMaxLengthAsString() {
        return this.format.format((long)this.getMaxLength()).toString();
    }

    public String getAvgLengthAsString() {
        return this.format.format(this.getAvgLength()).toString();
    }

    public String getEntropyAsString() {
        return this.format.format(this.getEntropy()).toString();
    }

    public Object value(String name) {
        try {
            return Metrics.valueOf(name).getFieldValue(this);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown value [" + name + "] in string stats aggregation");
        }
    }

    public InternalStringStats reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long count = 0L;
        long totalLength = 0L;
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        HashMap<String, Long> occurs = new HashMap<String, Long>();
        for (InternalAggregation aggregation : aggregations) {
            InternalStringStats stats = (InternalStringStats)aggregation;
            count += stats.getCount();
            minLength = Math.min(minLength, stats.getMinLength());
            maxLength = Math.max(maxLength, stats.getMaxLength());
            totalLength += stats.totalLength;
            stats.charOccurrences.forEach((k, v) -> occurs.merge((String)k, (Long)v, (oldValue, newValue) -> oldValue + newValue));
        }
        return new InternalStringStats(this.name, count, totalLength, minLength, maxLength, occurs, this.showDistribution, this.format, this.getMetadata());
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            return this.value(path.get(0));
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.COUNT.getPreferredName(), this.count);
        if (this.count > 0L) {
            builder.field(Fields.MIN_LENGTH.getPreferredName(), this.minLength);
            builder.field(Fields.MAX_LENGTH.getPreferredName(), this.maxLength);
            builder.field(Fields.AVG_LENGTH.getPreferredName(), this.getAvgLength());
            builder.field(Fields.ENTROPY.getPreferredName(), this.getEntropy());
            if (this.showDistribution) {
                builder.field(Fields.DISTRIBUTION.getPreferredName(), this.getDistribution());
            }
            if (this.format != DocValueFormat.RAW) {
                builder.field(Fields.MIN_LENGTH_AS_STRING.getPreferredName(), this.format.format((long)this.getMinLength()));
                builder.field(Fields.MAX_LENGTH_AS_STRING.getPreferredName(), this.format.format((long)this.getMaxLength()));
                builder.field(Fields.AVG_LENGTH_AS_STRING.getPreferredName(), this.format.format(this.getAvgLength()));
                builder.field(Fields.ENTROPY_AS_STRING.getPreferredName(), this.format.format(this.getEntropy()));
                if (this.showDistribution) {
                    builder.startObject(Fields.DISTRIBUTION_AS_STRING.getPreferredName());
                    for (Map.Entry<String, Double> e : this.getDistribution().entrySet()) {
                        builder.field(e.getKey(), this.format.format(e.getValue().doubleValue()).toString());
                    }
                    builder.endObject();
                }
            }
        } else {
            builder.nullField(Fields.MIN_LENGTH.getPreferredName());
            builder.nullField(Fields.MAX_LENGTH.getPreferredName());
            builder.nullField(Fields.AVG_LENGTH.getPreferredName());
            builder.field(Fields.ENTROPY.getPreferredName(), 0.0);
            if (this.showDistribution) {
                builder.nullField(Fields.DISTRIBUTION.getPreferredName());
            }
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.count, this.minLength, this.maxLength, this.totalLength, this.charOccurrences, this.showDistribution);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalStringStats other = (InternalStringStats)((Object)obj);
        return this.count == other.count && this.minLength == other.minLength && this.maxLength == other.maxLength && this.totalLength == other.totalLength && Objects.equals(this.charOccurrences, other.charOccurrences) && this.showDistribution == other.showDistribution;
    }

    static enum Metrics {
        count{

            @Override
            Object getFieldValue(InternalStringStats stats) {
                return stats.getCount();
            }
        }
        ,
        min_length{

            @Override
            Object getFieldValue(InternalStringStats stats) {
                return stats.getMinLength();
            }
        }
        ,
        max_length{

            @Override
            Object getFieldValue(InternalStringStats stats) {
                return stats.getMaxLength();
            }
        }
        ,
        avg_length{

            @Override
            Object getFieldValue(InternalStringStats stats) {
                return stats.getAvgLength();
            }
        }
        ,
        entropy{

            @Override
            Object getFieldValue(InternalStringStats stats) {
                return stats.getEntropy();
            }
        };


        abstract Object getFieldValue(InternalStringStats var1);
    }

    static class Fields {
        public static final ParseField COUNT = new ParseField("count", new String[0]);
        public static final ParseField MIN_LENGTH = new ParseField("min_length", new String[0]);
        public static final ParseField MIN_LENGTH_AS_STRING = new ParseField("min_length_as_string", new String[0]);
        public static final ParseField MAX_LENGTH = new ParseField("max_length", new String[0]);
        public static final ParseField MAX_LENGTH_AS_STRING = new ParseField("max_as_string", new String[0]);
        public static final ParseField AVG_LENGTH = new ParseField("avg_length", new String[0]);
        public static final ParseField AVG_LENGTH_AS_STRING = new ParseField("avg_length_as_string", new String[0]);
        public static final ParseField ENTROPY = new ParseField("entropy", new String[0]);
        public static final ParseField ENTROPY_AS_STRING = new ParseField("entropy_string", new String[0]);
        public static final ParseField DISTRIBUTION = new ParseField("distribution", new String[0]);
        public static final ParseField DISTRIBUTION_AS_STRING = new ParseField("distribution_string", new String[0]);

        Fields() {
        }
    }
}

